/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlInternalOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class SqlSetSemanticsTableOperator
extends SqlInternalOperator {
    public SqlSetSemanticsTableOperator() {
        super("SET_SEMANTICS_TABLE", SqlKind.SET_SEMANTICS_TABLE);
    }

    @Override
    public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        assert (operands.length == 3);
        SqlNode partitionList = operands[1];
        SqlNode orderList = operands[2];
        assert (partitionList != null && !SqlNodeList.isEmptyList(partitionList) || orderList != null && !SqlNodeList.isEmptyList(orderList));
        return super.createCall(functionQualifier, pos, operands);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlNodeList orderList;
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        SqlNodeList partitionList = (SqlNodeList)call.operand(1);
        if (partitionList.size() > 0) {
            writer.sep("PARTITION BY");
            SqlWriter.Frame partitionFrame = writer.startList("", "");
            partitionList.unparse(writer, 0, 0);
            writer.endList(partitionFrame);
        }
        if ((orderList = (SqlNodeList)call.operand(2)).size() > 0) {
            writer.sep("ORDER BY");
            writer.list(SqlWriter.FrameTypeEnum.ORDER_BY_LIST, SqlWriter.COMMA, orderList);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        RelDataType tableType = validator.deriveType(scope, operands.get(0));
        assert (tableType != null);
        return tableType;
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

