/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlAbstractStringLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.util.BitString;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import java.util.List;
import java.util.Objects;

public class SqlBinaryStringLiteral
extends SqlAbstractStringLiteral {
    protected SqlBinaryStringLiteral(BitString val, SqlParserPos pos) {
        super(val, SqlTypeName.BINARY, pos);
    }

    @Deprecated
    public BitString getBitString() {
        return this.getValueNonNull();
    }

    private BitString getValueNonNull() {
        return (BitString)Objects.requireNonNull(this.value, "value");
    }

    @Override
    public SqlBinaryStringLiteral clone(SqlParserPos pos) {
        return new SqlBinaryStringLiteral(this.getValueNonNull(), pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.literal("X'" + this.getValueNonNull().toHexString() + "'");
    }

    @Override
    protected SqlAbstractStringLiteral concat1(List<SqlLiteral> literals) {
        return new SqlBinaryStringLiteral(BitString.concat(Util.transform(literals, literal -> literal.getValueAs(BitString.class))), literals.get(0).getParserPosition());
    }
}

