/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.metadata;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.rel.BiRel;
import com.hazelcast.shaded.org.apache.calcite.rel.RelDistribution;
import com.hazelcast.shaded.org.apache.calcite.rel.RelDistributions;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.SingleRel;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Exchange;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Project;
import com.hazelcast.shaded.org.apache.calcite.rel.core.SetOp;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Values;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.BuiltInMetadata;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgram;
import com.hazelcast.shaded.org.apache.calcite.util.mapping.Mappings;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class RelMdDistribution
implements MetadataHandler<BuiltInMetadata.Distribution> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(new RelMdDistribution(), BuiltInMetadata.Distribution.Handler.class);

    private RelMdDistribution() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Distribution> getDef() {
        return BuiltInMetadata.Distribution.DEF;
    }

    public RelDistribution distribution(RelNode rel, RelMetadataQuery mq) {
        return RelDistributions.SINGLETON;
    }

    public RelDistribution distribution(SingleRel rel, RelMetadataQuery mq) {
        return mq.distribution(rel.getInput());
    }

    public RelDistribution distribution(BiRel rel, RelMetadataQuery mq) {
        return mq.distribution(rel.getLeft());
    }

    public RelDistribution distribution(SetOp rel, RelMetadataQuery mq) {
        return mq.distribution(rel.getInputs().get(0));
    }

    public RelDistribution distribution(TableModify rel, RelMetadataQuery mq) {
        return mq.distribution(rel.getInput());
    }

    public @Nullable RelDistribution distribution(TableScan scan, RelMetadataQuery mq) {
        BuiltInMetadata.Distribution.Handler handler = scan.getTable().unwrap(BuiltInMetadata.Distribution.Handler.class);
        if (handler != null) {
            return handler.distribution(scan, mq);
        }
        return RelMdDistribution.table(scan.getTable());
    }

    public RelDistribution distribution(Project project, RelMetadataQuery mq) {
        return RelMdDistribution.project(mq, project.getInput(), project.getProjects());
    }

    public RelDistribution distribution(Values values, RelMetadataQuery mq) {
        return RelMdDistribution.values(values.getRowType(), values.getTuples());
    }

    public RelDistribution distribution(Exchange exchange, RelMetadataQuery mq) {
        return RelMdDistribution.exchange(exchange.distribution);
    }

    public static @Nullable RelDistribution table(RelOptTable table) {
        return table.getDistribution();
    }

    public static RelDistribution snapshot(RelMetadataQuery mq, RelNode input) {
        return mq.distribution(input);
    }

    public static RelDistribution sort(RelMetadataQuery mq, RelNode input) {
        return mq.distribution(input);
    }

    public static RelDistribution filter(RelMetadataQuery mq, RelNode input) {
        return mq.distribution(input);
    }

    public static RelDistribution limit(RelMetadataQuery mq, RelNode input) {
        return mq.distribution(input);
    }

    public static RelDistribution calc(RelMetadataQuery mq, RelNode input, RexProgram program) {
        assert (program.getCondition() != null || !program.getProjectList().isEmpty());
        RelDistribution inputDistribution = mq.distribution(input);
        if (!program.getProjectList().isEmpty()) {
            Mappings.TargetMapping mapping = program.getPartialMapping(input.getRowType().getFieldCount());
            return inputDistribution.apply(mapping);
        }
        return inputDistribution;
    }

    public static RelDistribution project(RelMetadataQuery mq, RelNode input, List<? extends RexNode> projects) {
        RelDistribution inputDistribution = mq.distribution(input);
        Mappings.TargetMapping mapping = Project.getPartialMapping(input.getRowType().getFieldCount(), projects);
        return inputDistribution.apply(mapping);
    }

    public static RelDistribution values(RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        return RelDistributions.BROADCAST_DISTRIBUTED;
    }

    public static RelDistribution exchange(RelDistribution distribution) {
        return distribution;
    }
}

