/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.externalize;

import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.externalize.RelWriterImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlExplainLevel;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.XmlOutput;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RelXmlWriter
extends RelWriterImpl {
    private final XmlOutput xmlOutput;
    boolean generic = true;

    public RelXmlWriter(PrintWriter pw, SqlExplainLevel detailLevel) {
        super(pw, detailLevel, true);
        this.xmlOutput = new XmlOutput(pw);
        this.xmlOutput.setGlob(true);
        this.xmlOutput.setCompact(false);
    }

    @Override
    protected void explain_(RelNode rel, List<Pair<String, @Nullable Object>> values) {
        if (this.generic) {
            this.explainGeneric(rel, values);
        } else {
            this.explainSpecific(rel, values);
        }
    }

    private void explainGeneric(RelNode rel, List<Pair<String, @Nullable Object>> values) {
        String relType = rel.getRelTypeName();
        this.xmlOutput.beginBeginTag("RelNode");
        this.xmlOutput.attribute("type", relType);
        this.xmlOutput.endBeginTag("RelNode");
        ArrayList<RelNode> inputs = new ArrayList<RelNode>();
        for (Pair<String, Object> pair : values) {
            if (pair.right instanceof RelNode) {
                inputs.add((RelNode)pair.right);
                continue;
            }
            if (pair.right == null) continue;
            this.xmlOutput.beginBeginTag("Property");
            this.xmlOutput.attribute("name", (String)pair.left);
            this.xmlOutput.endBeginTag("Property");
            this.xmlOutput.cdata(pair.right.toString());
            this.xmlOutput.endTag("Property");
        }
        this.xmlOutput.beginTag("Inputs", null);
        this.spacer.add(2);
        for (RelNode input : inputs) {
            input.explain(this);
        }
        this.spacer.subtract(2);
        this.xmlOutput.endTag("Inputs");
        this.xmlOutput.endTag("RelNode");
    }

    private void explainSpecific(RelNode rel, List<Pair<String, @Nullable Object>> values) {
        String tagName = rel.getRelTypeName();
        this.xmlOutput.beginBeginTag(tagName);
        this.xmlOutput.attribute("id", rel.getId() + "");
        for (Pair<String, Object> value : values) {
            if (value.right instanceof RelNode) continue;
            this.xmlOutput.attribute((String)value.left, Objects.toString(value.right));
        }
        this.xmlOutput.endBeginTag(tagName);
        this.spacer.add(2);
        for (RelNode input : rel.getInputs()) {
            input.explain(this);
        }
        this.spacer.subtract(2);
    }
}

