/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.linq4j;

import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerator;
import com.hazelcast.shaded.org.apache.calcite.linq4j.MemoryFactory;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.concurrent.atomic.AtomicInteger;

public class MemoryEnumerator<@Nullable E>
implements Enumerator<MemoryFactory.Memory<E>> {
    private final Enumerator<E> enumerator;
    private final MemoryFactory<E> memoryFactory;
    private final AtomicInteger prevCounter;
    private final AtomicInteger postCounter;

    MemoryEnumerator(Enumerator<E> enumerator, int history, int future) {
        this.enumerator = enumerator;
        this.memoryFactory = new MemoryFactory(history, future);
        this.prevCounter = new AtomicInteger(future);
        this.postCounter = new AtomicInteger(future);
    }

    @Override
    public MemoryFactory.Memory<E> current() {
        return this.memoryFactory.create();
    }

    @Override
    public boolean moveNext() {
        if (this.prevCounter.get() > 0) {
            boolean lastMove = false;
            while (this.prevCounter.getAndDecrement() >= 0) {
                lastMove = this.moveNextInternal();
            }
            return lastMove;
        }
        return this.moveNextInternal();
    }

    private boolean moveNextInternal() {
        boolean moveNext = this.enumerator.moveNext();
        if (moveNext) {
            this.memoryFactory.add(this.enumerator.current());
            return true;
        }
        if (this.postCounter.getAndDecrement() > 0) {
            this.memoryFactory.add(null);
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.enumerator.reset();
    }

    @Override
    public void close() {
        this.enumerator.close();
    }
}

