/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.types;

import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastIntegerType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastIntegerTypeNameSpec;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastJsonType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastObjectType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlBasicCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlInsert;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUpdate;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.implicit.TypeCoercionImpl;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.List;
import java.util.function.Consumer;

public final class HazelcastTypeCoercion
extends TypeCoercionImpl {
    public HazelcastTypeCoercion(RelDataTypeFactory typeFactory, SqlValidator validator) {
        super(typeFactory, validator);
    }

    @Override
    public boolean coerceOperandType(SqlValidatorScope scope, SqlCall call, int index, RelDataType targetType) {
        Object operand = call.operand(index);
        return this.coerceNode(scope, (SqlNode)operand, targetType, cast -> call.setOperand(index, (SqlNode)cast));
    }

    private boolean coerceNode(SqlValidatorScope scope, SqlNode node, RelDataType targetType, Consumer<SqlNode> replaceFn) {
        if (!this.requiresCast(scope, node, targetType)) {
            this.updateInferredType(node, targetType);
            return false;
        }
        SqlDataTypeSpec targetTypeSpec = targetType instanceof HazelcastIntegerType ? new SqlDataTypeSpec(new HazelcastIntegerTypeNameSpec((HazelcastIntegerType)targetType), SqlParserPos.ZERO) : (targetType.getSqlTypeName() == SqlTypeName.ANY ? new SqlDataTypeSpec(new SqlUserDefinedTypeNameSpec("OBJECT", SqlParserPos.ZERO), SqlParserPos.ZERO).withNullable(targetType.isNullable()) : (targetType.getFamily() == HazelcastJsonType.FAMILY ? HazelcastJsonType.TYPE_SPEC : SqlTypeUtil.convertTypeToSpec(targetType)));
        SqlNode cast = HazelcastTypeCoercion.cast(node, targetTypeSpec);
        replaceFn.accept(cast);
        this.validator.deriveType(scope, cast);
        return true;
    }

    private static SqlNode cast(SqlNode node, SqlDataTypeSpec targetTypeSpec) {
        if (node.getKind() == SqlKind.ARGUMENT_ASSIGNMENT) {
            SqlBasicCall call = (SqlBasicCall)node;
            SqlNode value = call.getOperandList().get(0);
            SqlNode name = call.getOperandList().get(1);
            SqlNode cast = HazelcastTypeCoercion.cast(value, targetTypeSpec);
            return call.getOperator().createCall(SqlParserPos.ZERO, cast, name);
        }
        return HazelcastSqlOperatorTable.CAST.createCall(SqlParserPos.ZERO, node, targetTypeSpec);
    }

    private boolean requiresCast(SqlValidatorScope scope, SqlNode node, RelDataType to) {
        RelDataType from = this.validator.deriveType(scope, node);
        if (HazelcastTypeUtils.isNullOrUnknown(from.getSqlTypeName()) || SqlUtil.isNullLiteral(node, false) || node.getKind() == SqlKind.DYNAMIC_PARAM) {
            return false;
        }
        return from.getSqlTypeName() != to.getSqlTypeName();
    }

    @Override
    public boolean binaryArithmeticCoercion(SqlCallBinding binding) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean binaryComparisonCoercion(SqlCallBinding binding) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean rowTypeCoercion(SqlValidatorScope scope, SqlNode query, int columnIndex, RelDataType targetType) {
        switch (query.getKind()) {
            case SELECT: {
                SqlSelect selectNode = (SqlSelect)query;
                SqlValidatorScope selectScope = this.validator.getSelectScope(selectNode);
                if (!this.rowTypeElementCoercion(selectScope, selectNode.getSelectList().get(columnIndex), targetType, newNode -> selectNode.getSelectList().set(columnIndex, (SqlNode)newNode))) {
                    return false;
                }
                this.updateInferredColumnType(selectScope, query, columnIndex, targetType);
                return true;
            }
            case VALUES: {
                for (SqlNode rowConstructor : ((SqlCall)query).getOperandList()) {
                    if (this.rowTypeElementCoercion(scope, (SqlNode)((SqlCall)rowConstructor).operand(columnIndex), targetType, newNode -> ((SqlCall)rowConstructor).setOperand(columnIndex, (SqlNode)newNode))) continue;
                    return false;
                }
                this.updateInferredColumnType(scope, query, columnIndex, targetType);
                return true;
            }
        }
        throw new UnsupportedOperationException("unexpected: " + String.valueOf((Object)query.getKind()));
    }

    public boolean rowTypeElementCoercion(SqlValidatorScope scope, SqlNode rowElement, RelDataType targetType, Consumer<SqlNode> replaceFn) {
        boolean valid;
        if (targetType.equals(scope.getValidator().getUnknownType())) {
            return false;
        }
        RelDataType sourceType = this.validator.deriveType(scope, rowElement);
        QueryDataType sourceHzType = HazelcastTypeUtils.toHazelcastType(sourceType);
        QueryDataType targetHzType = HazelcastTypeUtils.toHazelcastType(targetType);
        if (sourceHzType.getTypeFamily() == targetHzType.getTypeFamily() || targetHzType == QueryDataType.OBJECT) {
            return true;
        }
        if (targetHzType.isCustomType() && (sourceHzType.getTypeFamily().equals((Object)QueryDataTypeFamily.ROW) || sourceHzType.isCustomType())) {
            return this.customTypesCoercion(sourceType, targetType, rowElement, scope);
        }
        boolean bl = valid = HazelcastTypeCoercion.sourceAndTargetAreNumeric(targetHzType, sourceHzType) || HazelcastTypeCoercion.sourceAndTargetAreTemporalAndSourceCanBeConvertedToTarget(targetHzType, sourceHzType) || HazelcastTypeCoercion.targetIsTemporalAndSourceIsVarcharLiteral(targetHzType, sourceHzType, rowElement) || sourceHzType.getTypeFamily() == QueryDataTypeFamily.NULL || sourceHzType.getTypeFamily() == QueryDataTypeFamily.VARCHAR && targetHzType.getTypeFamily() == QueryDataTypeFamily.JSON || sourceHzType.getTypeFamily() == QueryDataTypeFamily.JSON && targetHzType.getTypeFamily() == QueryDataTypeFamily.VARCHAR;
        if (!valid) {
            return false;
        }
        this.coerceNode(scope, rowElement, targetType, replaceFn);
        return true;
    }

    private boolean customTypesCoercion(RelDataType source, RelDataType target, SqlNode rowElement, SqlValidatorScope scope) {
        if (source.getFieldCount() != target.getFieldCount()) {
            return false;
        }
        if (rowElement.getKind() == SqlKind.AS) {
            return this.customTypesCoercion(source, target, (SqlNode)((SqlCall)rowElement).operand(0), scope);
        }
        if (source instanceof HazelcastObjectType) {
            return ((HazelcastObjectType)source).getTypeName().equals(((HazelcastObjectType)target).getTypeName());
        }
        assert (rowElement instanceof SqlCall) : "Row Element must be an SqlCall";
        assert (rowElement.getKind().equals((Object)SqlKind.ROW));
        SqlCall sourceCall = (SqlCall)rowElement;
        for (int i = 0; i < source.getFieldList().size(); ++i) {
            int currentIndex = i;
            RelDataTypeField targetField = target.getFieldList().get(i);
            SqlNode elementNode = sourceCall.getOperandList().get(i);
            if (this.rowTypeElementCoercion(scope, elementNode, targetField.getType(), node -> sourceCall.setOperand(currentIndex, (SqlNode)node))) continue;
            return false;
        }
        return true;
    }

    private static boolean sourceAndTargetAreNumeric(QueryDataType highHZType, QueryDataType lowHZType) {
        return highHZType.getTypeFamily().isNumeric() && lowHZType.getTypeFamily().isNumeric();
    }

    private static boolean sourceAndTargetAreTemporalAndSourceCanBeConvertedToTarget(QueryDataType targetHzType, QueryDataType sourceHzType) {
        return targetHzType.getTypeFamily().isTemporal() && sourceHzType.getTypeFamily().isTemporal() && sourceHzType.getConverter().canConvertTo(targetHzType.getTypeFamily());
    }

    private static boolean targetIsTemporalAndSourceIsVarcharLiteral(QueryDataType targetHzType, QueryDataType sourceHzType, SqlNode sourceNode) {
        SqlKind sourceKind = sourceNode.getKind();
        if (sourceKind == SqlKind.AS) {
            return HazelcastTypeCoercion.targetIsTemporalAndSourceIsVarcharLiteral(targetHzType, sourceHzType, ((SqlBasicCall)sourceNode).operand(0));
        }
        return targetHzType.getTypeFamily().isTemporal() && sourceHzType.getTypeFamily() == QueryDataTypeFamily.VARCHAR && sourceKind == SqlKind.LITERAL;
    }

    @Override
    public boolean caseWhenCoercion(SqlCallBinding callBinding) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean builtinFunctionCoercion(SqlCallBinding binding, List<RelDataType> operandTypes, List<SqlTypeFamily> expectedFamilies) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean userDefinedFunctionCoercion(SqlValidatorScope scope, SqlCall call, SqlFunction function) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean querySourceCoercion(SqlValidatorScope scope, RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
        List<RelDataTypeField> sourceFields = sourceRowType.getFieldList();
        List<RelDataTypeField> targetFields = targetRowType.getFieldList();
        assert (sourceFields.size() == targetFields.size());
        int fieldCount = sourceFields.size();
        for (int i = 0; i < fieldCount; ++i) {
            RelDataType sourceType = sourceFields.get(i).getType();
            RelDataType targetType = targetFields.get(i).getType();
            if ((SqlTypeUtil.equalSansNullability(this.validator.getTypeFactory(), sourceType, targetType) || HazelcastTypeUtils.canCast(sourceType, targetType)) && this.coerceSourceRowType(scope, query, i, fieldCount, targetType)) continue;
            SqlNode node = this.getNthExpr(query, i, fieldCount);
            throw scope.getValidator().newValidationError(node, Static.RESOURCE.typeNotAssignable(targetFields.get(i).getName(), targetType.toString(), sourceFields.get(i).getName(), sourceType.toString()));
        }
        return true;
    }

    private SqlNode getNthExpr(SqlNode query, int ordinal, int sourceCount) {
        if (query instanceof SqlInsert) {
            SqlInsert insert = (SqlInsert)query;
            if (insert.getTargetColumnList() != null) {
                return insert.getTargetColumnList().get(ordinal);
            }
            return this.getNthExpr(insert.getSource(), ordinal, sourceCount);
        }
        if (query instanceof SqlUpdate) {
            SqlUpdate update = (SqlUpdate)query;
            SqlNodeList selectList = update.getSourceSelect().getSelectList();
            return selectList.get(selectList.size() - sourceCount + ordinal);
        }
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            if (select.getSelectList().size() == sourceCount) {
                return select.getSelectList().get(ordinal);
            }
            return query;
        }
        return query;
    }

    private boolean coerceSourceRowType(SqlValidatorScope sourceScope, SqlNode query, int columnIndex, int totalColumns, RelDataType targetType) {
        switch (query.getKind()) {
            case INSERT: {
                SqlInsert insert = (SqlInsert)query;
                return this.coerceSourceRowType(sourceScope, insert.getSource(), columnIndex, totalColumns, targetType);
            }
            case UPDATE: {
                SqlUpdate update = (SqlUpdate)query;
                SqlNodeList selectList = update.getSourceSelect().getSelectList();
                return this.coerceSourceRowType(sourceScope, selectList, selectList.size() - totalColumns + columnIndex, targetType);
            }
        }
        return this.rowTypeCoercion(sourceScope, query, columnIndex, targetType);
    }

    private boolean coerceSourceRowType(SqlValidatorScope scope, SqlNodeList nodeList, int index, RelDataType targetType) {
        SqlNode node = nodeList.get(index);
        return this.rowTypeElementCoercion(scope, node, targetType, cast -> nodeList.set(index, (SqlNode)cast));
    }
}

