/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.types;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HazelcastObjectType
extends RelDataTypeImpl {
    private final String name;
    private final boolean nullable;
    private ImmutableList.Builder<Field> fieldsBuilder = ImmutableList.builder();
    private List<Field> fields;
    private List<String> fieldNames;

    public HazelcastObjectType(String name) {
        this(name, true);
    }

    public HazelcastObjectType(String name, boolean nullable) {
        super(null);
        this.name = name;
        this.nullable = nullable;
    }

    public String getTypeName() {
        return this.name;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return SqlTypeName.OTHER;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        if (withDetail) {
            this.generateFullTypeString(sb, new HashSet<String>());
        } else {
            sb.append(this.name);
        }
    }

    private void generateFullTypeString(StringBuilder sb, Set<String> seen) {
        HazelcastObjectType.escape(sb, this.name);
        if (seen.contains(this.name)) {
            return;
        }
        seen.add(this.name);
        sb.append('(');
        Iterator<RelDataTypeField> it = this.getFieldList().iterator();
        while (it.hasNext()) {
            RelDataTypeField field = it.next();
            HazelcastObjectType.escape(sb, field.getName());
            sb.append(':');
            if (field.getType() instanceof HazelcastObjectType) {
                ((HazelcastObjectType)field.getType()).generateFullTypeString(sb, seen);
            } else {
                sb.append(field.getType().getFullTypeString());
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
    }

    private static void escape(StringBuilder sb, String value) {
        for (char c : value.toCharArray()) {
            if (c == '(' || c == ':' || c == ',' || c == ')') {
                sb.append('\\');
            }
            sb.append(c);
        }
    }

    public void addField(Field field) {
        if (this.fieldsBuilder == null) {
            throw new IllegalStateException("Type fields are already finalized");
        }
        this.fieldsBuilder.add((Object)field);
    }

    public static void finalizeFields(Collection<HazelcastObjectType> types) {
        types.forEach(type -> {
            if (type.fieldsBuilder == null) {
                throw new IllegalStateException("Type fields are already finalized");
            }
            type.fields = type.fieldsBuilder.build();
            type.fieldsBuilder = null;
        });
        types.forEach(type -> type.computeDigest());
    }

    @Override
    public @Nullable RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
        assert (!elideRecord);
        for (RelDataTypeField field : this.getFieldList()) {
            if (!fieldName.equals(field.getName())) continue;
            return new RelDataTypeFieldImpl(fieldName, field.getIndex(), field.getType());
        }
        return null;
    }

    @Override
    public List<RelDataTypeField> getFieldList() {
        if (this.fields == null) {
            throw new IllegalStateException("Type fields are not finalized");
        }
        return this.fields;
    }

    @Override
    public List<String> getFieldNames() {
        if (this.fieldNames == null) {
            this.fieldNames = this.getFieldList().stream().map(RelDataTypeField::getName).collect(Collectors.toUnmodifiableList());
        }
        return this.fieldNames;
    }

    @Override
    public int getFieldCount() {
        return this.getFieldList().size();
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    public static class Field
    extends RelDataTypeFieldImpl {
        public Field(String name, int index, RelDataType type) {
            super(name, index, type);
        }
    }
}

