/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.types;

import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeSystem;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.type.BasicSqlType;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import java.util.HashMap;
import java.util.Map;

public final class HazelcastIntegerType
extends BasicSqlType {
    private static final Map<SqlTypeName, HazelcastIntegerType[]> TYPES = new HashMap<SqlTypeName, HazelcastIntegerType[]>();
    private static final Map<SqlTypeName, HazelcastIntegerType[]> NULLABLE_TYPES = new HashMap<SqlTypeName, HazelcastIntegerType[]>();
    private static final HazelcastIntegerType[] TYPES_BY_BIT_WIDTH = new HazelcastIntegerType[65];
    private static final HazelcastIntegerType[] NULLABLE_TYPES_BY_BIT_WIDTH = new HazelcastIntegerType[65];
    private final int bitWidth;

    private HazelcastIntegerType(SqlTypeName typeName, boolean nullable, int bitWidth) {
        super(HazelcastTypeSystem.INSTANCE, typeName);
        this.isNullable = nullable;
        this.bitWidth = bitWidth;
        this.computeDigest();
    }

    public int getBitWidth() {
        return this.bitWidth;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        super.generateTypeString(sb, withDetail);
        if (withDetail) {
            sb.append('(').append(this.bitWidth).append(')');
        }
    }

    public static RelDataType create(HazelcastIntegerType type, boolean nullable) {
        if (type.isNullable() == nullable) {
            return type;
        }
        return HazelcastIntegerType.create0(type.getSqlTypeName(), nullable, type.getBitWidth());
    }

    public static HazelcastIntegerType create(SqlTypeName typeName, boolean nullable) {
        return HazelcastIntegerType.create0(typeName, nullable, HazelcastIntegerType.bitWidthOf(typeName));
    }

    private static HazelcastIntegerType create0(SqlTypeName typeName, boolean nullable, int bitWidth) {
        if (nullable) {
            return NULLABLE_TYPES.get((Object)typeName)[bitWidth];
        }
        return TYPES.get((Object)typeName)[bitWidth];
    }

    public static HazelcastIntegerType create(int bitWidth, boolean nullable) {
        assert (bitWidth >= 0);
        if (nullable) {
            return NULLABLE_TYPES_BY_BIT_WIDTH[Math.min(bitWidth, 64)];
        }
        return TYPES_BY_BIT_WIDTH[Math.min(bitWidth, 64)];
    }

    public static int bitWidthOf(long value) {
        if (value == Long.MIN_VALUE) {
            return 63;
        }
        if (value == Integer.MIN_VALUE) {
            return 31;
        }
        if (value == -32768L) {
            return 15;
        }
        if (value == -128L) {
            return 7;
        }
        value = Math.abs(value);
        return 64 - Long.numberOfLeadingZeros(value);
    }

    static int bitWidthOf(SqlTypeName typeName) {
        switch (typeName) {
            case TINYINT: {
                return 7;
            }
            case SMALLINT: {
                return 15;
            }
            case INTEGER: {
                return 31;
            }
            case BIGINT: {
                return 63;
            }
        }
        throw new IllegalArgumentException("unexpected type: " + String.valueOf((Object)typeName));
    }

    static {
        TYPES.put(SqlTypeName.TINYINT, new HazelcastIntegerType[9]);
        TYPES.put(SqlTypeName.SMALLINT, new HazelcastIntegerType[17]);
        TYPES.put(SqlTypeName.INTEGER, new HazelcastIntegerType[33]);
        TYPES.put(SqlTypeName.BIGINT, new HazelcastIntegerType[65]);
        for (Map.Entry<SqlTypeName, HazelcastIntegerType[]> entry : TYPES.entrySet()) {
            SqlTypeName typeName = entry.getKey();
            HazelcastIntegerType[] types = entry.getValue();
            HazelcastIntegerType[] nullableTypes = new HazelcastIntegerType[types.length];
            NULLABLE_TYPES.put(typeName, nullableTypes);
            for (int i = 0; i < types.length; ++i) {
                types[i] = new HazelcastIntegerType(typeName, false, i);
                nullableTypes[i] = new HazelcastIntegerType(typeName, true, i);
            }
        }
        for (int i = 0; i <= 64; ++i) {
            HazelcastIntegerType nullableType;
            HazelcastIntegerType type;
            if (i < 8) {
                type = TYPES.get((Object)SqlTypeName.TINYINT)[i];
                nullableType = NULLABLE_TYPES.get((Object)SqlTypeName.TINYINT)[i];
            } else if (i < 16) {
                type = TYPES.get((Object)SqlTypeName.SMALLINT)[i];
                nullableType = NULLABLE_TYPES.get((Object)SqlTypeName.SMALLINT)[i];
            } else if (i < 32) {
                type = TYPES.get((Object)SqlTypeName.INTEGER)[i];
                nullableType = NULLABLE_TYPES.get((Object)SqlTypeName.INTEGER)[i];
            } else {
                type = TYPES.get((Object)SqlTypeName.BIGINT)[i];
                nullableType = NULLABLE_TYPES.get((Object)SqlTypeName.BIGINT)[i];
            }
            HazelcastIntegerType.TYPES_BY_BIT_WIDTH[i] = type;
            HazelcastIntegerType.NULLABLE_TYPES_BY_BIT_WIDTH[i] = nullableType;
        }
    }
}

