/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBindingSignatureErrorAware;
import com.hazelcast.jet.sql.impl.validate.HazelcastResources;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.runtime.CalciteException;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collection;
import java.util.StringJoiner;

public class HazelcastCallBinding
extends SqlCallBinding {
    public HazelcastCallBinding(SqlCallBinding binding) {
        super(binding.getValidator(), binding.getScope(), binding.getCall());
    }

    @Override
    public HazelcastSqlValidator getValidator() {
        return (HazelcastSqlValidator)super.getValidator();
    }

    @Override
    public CalciteException newValidationSignatureError() {
        SqlOperator operator = this.getOperator();
        HazelcastSqlValidator validator = this.getValidator();
        SqlCall call = this.getCall();
        String operandTypes = HazelcastCallBinding.getOperandTypes(validator, call, this.getScope());
        String operatorName = "'" + operator.getName() + "'";
        return validator.newValidationError(call, switch (operator.getSyntax()) {
            case SqlSyntax.FUNCTION, SqlSyntax.FUNCTION_STAR, SqlSyntax.FUNCTION_ID -> HazelcastResources.RESOURCES.invalidFunctionOperands(operatorName, operandTypes);
            default -> HazelcastResources.RESOURCES.invalidOperatorOperands(operatorName, operandTypes);
        });
    }

    private static String getOperandTypes(SqlValidator validator, SqlCall call, SqlValidatorScope scope) {
        StringJoiner res = new StringJoiner(", ", "[", "]");
        for (SqlNode operand : HazelcastCallBinding.getOperands(call)) {
            QueryDataType hazelcastType;
            RelDataType calciteType = validator.deriveType(scope, operand);
            SqlTypeName sqlTypeName = calciteType.getSqlTypeName();
            String typeName = sqlTypeName == SqlTypeName.NULL || sqlTypeName == SqlTypeName.UNKNOWN || sqlTypeName == SqlTypeName.ROW || sqlTypeName == SqlTypeName.COLUMN_LIST || sqlTypeName == SqlTypeName.SYMBOL || sqlTypeName == SqlTypeName.CURSOR ? sqlTypeName.toString() : ((hazelcastType = HazelcastTypeUtils.toHazelcastType(calciteType)).getTypeFamily().getPublicType() != null ? hazelcastType.getTypeFamily().getPublicType().toString() : sqlTypeName.toString());
            res.add(typeName);
        }
        return res.toString();
    }

    private static Collection<SqlNode> getOperands(SqlCall call) {
        SqlOperator operator = call.getOperator();
        if (operator instanceof HazelcastCallBindingSignatureErrorAware) {
            return ((HazelcastCallBindingSignatureErrorAware)((Object)operator)).getOperandsForSignatureError(call);
        }
        return call.getOperandList();
    }
}

