/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.jet.sql.impl.parse.UnparseUtil;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.jet.sql.impl.validate.operators.special.HazelcastCreateDataConnectionOperator;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCreate;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class SqlCreateDataConnection
extends SqlCreate {
    public static final SqlOperator CREATE_DATA_CONNECTION = new HazelcastCreateDataConnectionOperator();
    private final SqlIdentifier name;
    private final SqlIdentifier type;
    private final boolean shared;
    private final SqlNodeList options;

    public SqlCreateDataConnection(SqlParserPos pos, boolean replace, boolean ifNotExists, @Nonnull SqlIdentifier name, @Nonnull SqlIdentifier type, boolean shared, @Nonnull SqlNodeList options) {
        super(CREATE_DATA_CONNECTION, pos, replace, ifNotExists);
        this.name = name;
        this.type = type;
        this.shared = shared;
        this.options = options;
    }

    public String nameWithoutSchema() {
        return (String)this.name.names.get(this.name.names.size() - 1);
    }

    public String type() {
        return this.type.toString();
    }

    public boolean shared() {
        return this.shared;
    }

    public Map<String, String> options() {
        return this.options.getList().stream().map(node -> (SqlOption)node).collect(LinkedHashMap::new, (map, option) -> map.putIfAbsent(option.keyString(), option.valueString()), Map::putAll);
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.name, this.type, this.options);
    }

    @Override
    public SqlOperator getOperator() {
        return CREATE_DATA_CONNECTION;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.getReplace()) {
            writer.keyword("CREATE OR REPLACE");
        } else {
            writer.keyword("CREATE");
        }
        writer.keyword("DATA CONNECTION");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        writer.newlineAndIndent();
        writer.keyword("TYPE");
        this.type.unparse(writer, leftPrec, rightPrec);
        writer.newlineAndIndent();
        if (!this.shared) {
            writer.keyword("NOT");
        }
        writer.keyword("SHARED");
        UnparseUtil.unparseOptions(writer, this.options);
    }

    @Nonnull
    public static String unparse(@Nonnull DataConnectionCatalogEntry dataConnection) {
        SqlPrettyWriter writer = new SqlPrettyWriter(SqlPrettyWriter.config());
        SqlCreateDataConnection d = new SqlCreateDataConnection(SqlParserPos.ZERO, true, false, UnparseUtil.identifier("hazelcast", "public", dataConnection.name()), UnparseUtil.identifier(dataConnection.type()), dataConnection.isShared(), UnparseUtil.nodeList(dataConnection.options().entrySet(), o -> new SqlOption(SqlLiteral.createCharString((String)o.getKey(), SqlParserPos.ZERO), SqlLiteral.createCharString((String)o.getValue(), SqlParserPos.ZERO), SqlParserPos.ZERO)));
        d.unparse(writer, 0, 0);
        return writer.toString();
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.getReplace() && this.ifNotExists) {
            throw validator.newValidationError(this, ParserResource.RESOURCE.orReplaceWithIfNotExistsNotSupported());
        }
        if (!ValidationUtil.isCatalogObjectNameValid(this.name)) {
            throw validator.newValidationError(this, ParserResource.RESOURCE.dataConnectionIncorrectSchemaCreate());
        }
    }
}

