/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical.index;

import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.impl.opt.physical.index.IndexComponentCandidate;
import com.hazelcast.jet.sql.impl.opt.physical.index.IndexComponentFilter;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.exec.scan.index.IndexCompositeFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexEqualsFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilterValue;
import com.hazelcast.sql.impl.exec.scan.index.IndexRangeFilter;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

final class IndexComponentFilterResolver {
    private static final Predicate<IndexCompositeFilter> ONLY_EQUALS_FILTERS_PREDICATE = indexCompositeFilter -> indexCompositeFilter.getFilters().stream().allMatch(indexFilter -> indexFilter instanceof IndexEqualsFilter);
    private static final Predicate<IndexCompositeFilter> ALL_FILTERS_PREDICATE = indexFilter -> true;

    private IndexComponentFilterResolver() {
    }

    static IndexComponentFilter findBestComponentFilter(IndexType type, List<IndexComponentCandidate> candidates, QueryDataType converterType) {
        IndexComponentFilter equalityComponentFilter = IndexComponentFilterResolver.searchForEquality(candidates, converterType);
        if (equalityComponentFilter != null) {
            return equalityComponentFilter;
        }
        return IndexComponentFilterResolver.searchForRange(type, candidates, converterType);
    }

    private static IndexComponentFilter searchForEquality(List<IndexComponentCandidate> candidates, QueryDataType converterType) {
        IndexComponentFilter candidate = IndexComponentFilterResolver.convertFromEqualsFilter(candidates, converterType);
        if (candidate != null) {
            return candidate;
        }
        return IndexComponentFilterResolver.convertFromCompositeFilter(candidates, converterType, ONLY_EQUALS_FILTERS_PREDICATE);
    }

    private static IndexComponentFilter searchForRange(IndexType type, List<IndexComponentCandidate> candidates, QueryDataType converterType) {
        if (type != IndexType.SORTED) {
            return null;
        }
        IndexComponentFilter filter = IndexComponentFilterResolver.convertFromRangeFilters(candidates, converterType);
        if (filter != null) {
            return filter;
        }
        return IndexComponentFilterResolver.convertFromCompositeFilter(candidates, converterType, ALL_FILTERS_PREDICATE);
    }

    private static IndexComponentFilter convertFromEqualsFilter(List<IndexComponentCandidate> candidates, QueryDataType converterType) {
        for (IndexComponentCandidate candidate : candidates) {
            if (!(candidate.getFilter() instanceof IndexEqualsFilter)) continue;
            return new IndexComponentFilter(candidate.getFilter(), Collections.singletonList(candidate.getExpression()), converterType);
        }
        return null;
    }

    private static IndexComponentFilter convertFromRangeFilters(List<IndexComponentCandidate> candidates, QueryDataType converterType) {
        IndexFilterValue from = null;
        boolean fromInclusive = false;
        IndexFilterValue to = null;
        boolean toInclusive = false;
        boolean found = false;
        ArrayList<RexNode> expressions = new ArrayList<RexNode>(2);
        for (IndexComponentCandidate candidate : candidates) {
            if (!(candidate.getFilter() instanceof IndexRangeFilter)) continue;
            found = true;
            IndexRangeFilter candidateFilter = (IndexRangeFilter)candidate.getFilter();
            if (from == null && candidateFilter.getFrom() != null) {
                from = candidateFilter.getFrom();
                fromInclusive = candidateFilter.isFromInclusive();
                expressions.add(candidate.getExpression());
            }
            if (to == null && candidateFilter.getTo() != null) {
                to = candidateFilter.getTo();
                toInclusive = candidateFilter.isToInclusive();
                expressions.add(candidate.getExpression());
            }
            if (from != null || to != null || candidateFilter.getFrom() != null || candidateFilter.getTo() != null) continue;
            expressions.add(candidate.getExpression());
        }
        if (found) {
            IndexRangeFilter filter = new IndexRangeFilter(from, fromInclusive, to, toInclusive);
            return new IndexComponentFilter(filter, expressions, converterType);
        }
        return null;
    }

    private static IndexComponentFilter convertFromCompositeFilter(List<IndexComponentCandidate> candidates, QueryDataType converterType, Predicate<IndexCompositeFilter> additionalFilter) {
        for (IndexComponentCandidate candidate : candidates) {
            if (!(candidate.getFilter() instanceof IndexCompositeFilter) || !additionalFilter.test((IndexCompositeFilter)candidate.getFilter())) continue;
            return new IndexComponentFilter(candidate.getFilter(), Collections.singletonList(candidate.getExpression()), converterType);
        }
        return null;
    }
}

