/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.sql.impl.aggregate.WindowUtils;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.JoinPhysicalRel;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Join;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class StreamToStreamJoinPhysicalRel
extends JoinPhysicalRel {
    private final Map<Integer, Map<Integer, Long>> postponeTimeMap;

    StreamToStreamJoinPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Map<Integer, Map<Integer, Long>> postponeTimeMap) {
        super(cluster, traitSet, left, right, condition, joinType);
        this.postponeTimeMap = postponeTimeMap;
        assert (!postponeTimeMap.isEmpty());
    }

    public Map<Integer, ToLongFunctionEx<JetSqlRow>> leftTimeExtractors() {
        return this.timeExtractors(this.getLeft());
    }

    public Map<Integer, ToLongFunctionEx<JetSqlRow>> rightTimeExtractors() {
        return this.timeExtractors(this.getRight());
    }

    private Map<Integer, ToLongFunctionEx<JetSqlRow>> timeExtractors(RelNode input) {
        HashMap<Integer, ToLongFunctionEx<JetSqlRow>> timeExtractors = new HashMap<Integer, ToLongFunctionEx<JetSqlRow>>();
        for (Integer i : OptUtils.metadataQuery(this).extractWatermarkedFields(input).getFieldIndexes()) {
            timeExtractors.put(i, (ToLongFunctionEx<JetSqlRow>)(ToLongFunctionEx & Serializable)row -> WindowUtils.extractMillis(row.getRow().get(i.intValue())));
        }
        return timeExtractors;
    }

    public Map<Integer, Map<Integer, Long>> postponeTimeMap() {
        return this.postponeTimeMap;
    }

    public long minimumSpread() {
        return StreamToStreamJoinPhysicalRel.minimumSpread(this.postponeTimeMap, this.left.getRowType().getFieldCount());
    }

    static long minimumSpread(Map<Integer, Map<Integer, Long>> postponeTimeMap, int leftColumns) {
        long[] min2 = new long[]{Long.MAX_VALUE, Long.MAX_VALUE};
        for (Map.Entry<Integer, Map<Integer, Long>> outerEntry : postponeTimeMap.entrySet()) {
            for (Map.Entry<Integer, Long> innerEntry : outerEntry.getValue().entrySet()) {
                int side = outerEntry.getKey() < leftColumns ? 0 : 1;
                min2[side] = Math.min(min2[side], innerEntry.getValue());
            }
        }
        assert (min2[0] < Long.MAX_VALUE && min2[1] < Long.MAX_VALUE);
        long spread = min2[0] + min2[1];
        return Math.max(spread, 1L);
    }

    @Override
    public <V> V accept(CreateDagVisitor<V> visitor) {
        return visitor.onStreamToStreamJoin(this);
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new StreamToStreamJoinPhysicalRel(this.getCluster(), traitSet, left, right, this.getCondition(), joinType, this.postponeTimeMap);
    }
}

