/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.physical.DropLateItemsPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ImmutableStreamToStreamJoinDropLateItemsEliminateRule;
import com.hazelcast.jet.sql.impl.opt.physical.StreamToStreamJoinPhysicalRel;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.plan.volcano.HazelcastRelSubsetUtil;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.TransformationRule;
import org.immutables.value.Value;

@Value.Enclosing
public class StreamToStreamJoinDropLateItemsEliminateRule
extends RelRule<RelRule.Config>
implements TransformationRule {
    public static final RelOptRule INSTANCE = new StreamToStreamJoinDropLateItemsEliminateRule(Config.DEFAULT);

    protected StreamToStreamJoinDropLateItemsEliminateRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        StreamToStreamJoinPhysicalRel newJoin;
        StreamToStreamJoinPhysicalRel join = (StreamToStreamJoinPhysicalRel)call.rel(0);
        DropLateItemsPhysicalRel drop = (DropLateItemsPhysicalRel)call.rel(1);
        RelNode leftInput = join.getLeft();
        RelNode rightInput = join.getRight();
        if (drop == HazelcastRelSubsetUtil.unwrapSubset(leftInput)) {
            newJoin = (StreamToStreamJoinPhysicalRel)join.copy(join.getTraitSet(), join.getCondition(), drop.getInput(), rightInput, join.getJoinType(), join.isSemiJoinDone());
        } else if (drop == HazelcastRelSubsetUtil.unwrapSubset(rightInput)) {
            newJoin = (StreamToStreamJoinPhysicalRel)join.copy(join.getTraitSet(), join.getCondition(), leftInput, drop.getInput(), join.getJoinType(), join.isSemiJoinDone());
        } else {
            throw new AssertionError((Object)"Drop rel is neither left, nor right input of the Join rel");
        }
        call.transformTo(newJoin);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableStreamToStreamJoinDropLateItemsEliminateRule.Config.builder().description(StreamToStreamJoinDropLateItemsEliminateRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(StreamToStreamJoinPhysicalRel.class).trait(Conventions.PHYSICAL).unorderedInputs(b1 -> b1.operand(DropLateItemsPhysicalRel.class).anyInputs())).build();

        @Override
        default public RelOptRule toRule() {
            return new StreamToStreamJoinDropLateItemsEliminateRule(this);
        }
    }
}

