/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.opt.ExpressionValues;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SinkMapPhysicalRel
extends AbstractRelNode
implements PhysicalRel {
    private final RelOptTable table;
    private final List<ExpressionValues> values;

    SinkMapPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, List<ExpressionValues> values) {
        super(cluster, traitSet);
        assert (table.unwrap(HazelcastTable.class).getTarget() instanceof PartitionedMapTable);
        this.table = table;
        this.values = values;
    }

    public String mapName() {
        return this.table().getMapName();
    }

    public PlanObjectKey objectKey() {
        return this.table().getObjectKey();
    }

    public Function<ExpressionEvalContext, Map<Object, Object>> entriesFn() {
        PartitionedMapTable table = this.table();
        List<ExpressionValues> values = this.values;
        return evalContext -> {
            KvProjector projector = KvProjector.supplier(table.paths(), table.types(), (UpsertTargetDescriptor)table.getKeyJetMetadata(), (UpsertTargetDescriptor)table.getValueJetMetadata(), true).get((ExpressionEvalContext)evalContext);
            return values.stream().flatMap(vs -> vs.toValues((ExpressionEvalContext)evalContext)).map(projector::project).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        };
    }

    private PartitionedMapTable table() {
        return (PartitionedMapTable)this.table.unwrap(HazelcastTable.class).getTarget();
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V> V accept(CreateDagVisitor<V> visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RelDataType deriveRowType() {
        return RelOptUtil.createDmlRowType(SqlKind.INSERT, this.getCluster().getTypeFactory());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.item("table", this.table.getQualifiedName()).item("values", this.values);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new SinkMapPhysicalRel(this.getCluster(), traitSet, this.table, this.values);
    }
}

