/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.opt.ImmutableExtractUpdateExpressionsRule;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalTableModify;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexPermuteInputsShuttle;
import com.hazelcast.shaded.org.apache.calcite.util.Permutation;
import com.hazelcast.shaded.org.apache.calcite.util.mapping.Mapping;
import com.hazelcast.shaded.org.apache.calcite.util.mapping.Mappings;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.util.ArrayList;
import java.util.List;
import org.immutables.value.Value;

@Value.Enclosing
public class ExtractUpdateExpressionsRule
extends RelRule<RelRule.Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    public ExtractUpdateExpressionsRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        TableModify update = (TableModify)call.rel(0);
        assert (update.getSourceExpressionList() != null);
        if (OptUtils.hasTableType(update, PartitionedMapTable.class)) {
            return;
        }
        HazelcastTable hzTable = OptUtils.extractHazelcastTable(update);
        Object sqlConnector = SqlConnectorUtil.getJetSqlConnector(hzTable.getTarget());
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        List<RexNode> projections = new ArrayList<RexNode>();
        for (int i = 0; i < update.getInput().getRowType().getFieldCount(); ++i) {
            projections.add(rexBuilder.makeInputRef(update.getInput(), i));
        }
        boolean expressionsAdded = false;
        ArrayList<RexNode> sourceExpressions = new ArrayList<RexNode>(update.getSourceExpressionList());
        for (int i = 0; i < sourceExpressions.size(); ++i) {
            RexNode expr2 = (RexNode)sourceExpressions.get(i);
            if (expr2 instanceof RexInputRef || sqlConnector.supportsExpression(HazelcastRexNode.wrap(expr2))) continue;
            expressionsAdded = true;
            sourceExpressions.set(i, rexBuilder.makeInputRef(expr2.getType(), projections.size()));
            projections.add(expr2);
        }
        Permutation permutation = this.permutePkFieldsToBeginning(sqlConnector.getPrimaryKey((Table)hzTable.getTarget()), update.getInput().getRowType());
        if (expressionsAdded || !permutation.isIdentity()) {
            permutation.set(projections.size() - 1, projections.size() - 1, true);
            projections = Mappings.apply((Mapping)permutation, projections);
            RelNode newProject = call.builder().push(update.getInput()).project(projections).build();
            if (!permutation.isIdentity()) {
                RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)permutation, newProject);
                sourceExpressions.replaceAll(expr -> expr.accept(shuttle));
            }
            LogicalTableModify newUpdate = new LogicalTableModify(update.getCluster(), update.getTraitSet(), update.getTable(), update.getCatalogReader(), newProject, update.getOperation(), update.getUpdateColumnList(), sourceExpressions, update.isFlattened());
            call.transformTo(newUpdate);
        }
    }

    private Permutation permutePkFieldsToBeginning(List<String> primaryKey, RelDataType rowType) {
        List<RelDataTypeField> fieldList = rowType.getFieldList();
        Permutation result = new Permutation(rowType.getFieldCount());
        for (int i = 0; i < primaryKey.size(); ++i) {
            int j;
            block3: {
                for (j = 0; j < fieldList.size(); ++j) {
                    if (!fieldList.get(j).getName().equals(primaryKey.get(i))) {
                        continue;
                    }
                    break block3;
                }
                throw new RuntimeException("PK field not found in the input row: " + primaryKey.get(i));
            }
            result.set(j, i);
        }
        return result;
    }

    @Value.Immutable
    static interface Config
    extends RelRule.Config {
        public static final RelRule.Config DEFAULT = ImmutableExtractUpdateExpressionsRule.Config.builder().description(ExtractUpdateExpressionsRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(TableModify.class).predicate(TableModify::isUpdate).anyInputs()).build();

        @Override
        default public RelOptRule toRule() {
            return new ExtractUpdateExpressionsRule(this);
        }
    }
}

