/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.jet.sql.impl.inject.AvroUpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.io.IOException;
import java.util.Objects;
import org.apache.avro.Schema;

public final class AvroUpsertTargetDescriptor
implements UpsertTargetDescriptor {
    private Schema schema;
    private transient String serializedSchema;

    private AvroUpsertTargetDescriptor() {
    }

    public AvroUpsertTargetDescriptor(Schema schema) {
        this.schema = schema;
    }

    @Override
    public UpsertTarget create(ExpressionEvalContext evalContext) {
        return new AvroUpsertTarget(this.schema);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        if (this.serializedSchema == null) {
            this.serializedSchema = this.schema.toString();
        }
        out.writeObject((Object)this.serializedSchema);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.serializedSchema = (String)in.readObject();
        this.schema = new Schema.Parser().parse(this.serializedSchema);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroUpsertTargetDescriptor that = (AvroUpsertTargetDescriptor)o;
        return Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.schema);
    }
}

