/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.shaded.com.google.gson.Gson;
import com.hazelcast.shaded.com.google.gson.GsonBuilder;
import com.hazelcast.shaded.com.google.gson.JsonPrimitive;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;

public final class JsonCreationUtil {
    private static final Gson SERIALIZER = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();

    private JsonCreationUtil() {
    }

    public static String serializeValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof HazelcastJsonValue) {
            return value.toString();
        }
        Converter converter = Converters.getConverter(value.getClass());
        return SERIALIZER.toJson(switch (converter.getTypeFamily()) {
            case QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE -> converter.asVarchar(value);
            default -> value;
        });
    }

    public static String serializeString(String string) {
        if (string == null) {
            return "null";
        }
        return SERIALIZER.toJson(new JsonPrimitive(string));
    }
}

