/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.map.Metadata;
import com.hazelcast.jet.sql.impl.connector.map.SampleMetadataResolver;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.impl.schema.IMapResolver;
import com.hazelcast.sql.impl.schema.Mapping;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class MetadataResolver
implements IMapResolver {
    private final NodeEngine nodeEngine;

    public MetadataResolver(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    @Nullable
    public Mapping resolve(String iMapName) {
        MapService service = (MapService)this.nodeEngine.getService("hz:impl:mapService");
        MapServiceContext context = service.getMapServiceContext();
        MapContainer container = context.getExistingMapContainer(iMapName);
        if (container == null) {
            return null;
        }
        boolean hd = container.getMapConfig().getInMemoryFormat() == InMemoryFormat.NATIVE && !container.getMapConfig().getTieredStoreConfig().isEnabled();
        Metadata metadata = hd ? this.resolveFromContentsHd(iMapName, context) : this.resolveFromContents(iMapName, context);
        return metadata == null ? null : new Mapping(iMapName, iMapName, null, "IMap", null, metadata.fields(), metadata.options());
    }

    @Nullable
    private Metadata resolveFromContents(String name, MapServiceContext context) {
        for (PartitionContainer partitionContainer : context.getPartitionContainers()) {
            RecordStore recordStore = partitionContainer.getExistingRecordStore(name);
            Metadata resolved = MetadataResolver.resolveFromContentsRecordStore(this.nodeEngine, recordStore);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    private Metadata resolveFromContentsHd(String name, MapServiceContext context) {
        for (PartitionContainer partitionContainer : context.getPartitionContainers()) {
            GetAnyMetadataRunnable partitionTask = new GetAnyMetadataRunnable(context, name, partitionContainer.getPartitionId());
            if (!partitionTask.hasRecordStore()) continue;
            this.nodeEngine.getOperationService().execute((PartitionSpecificRunnable)partitionTask);
            if (partitionTask.getResult() == null) continue;
            return partitionTask.getResult();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Metadata resolveFromContentsRecordStore(NodeEngine nodeEngine, RecordStore<?> recordStore) {
        if (recordStore == null) {
            return null;
        }
        recordStore.beforeOperation();
        try {
            Iterator recordStoreIterator = recordStore.iterator();
            if (!recordStoreIterator.hasNext()) {
                Metadata metadata = null;
                return metadata;
            }
            Map.Entry entry = (Map.Entry)recordStoreIterator.next();
            Metadata metadata = MetadataResolver.resolveMetadata(nodeEngine, entry.getKey(), ((Record)entry.getValue()).getValue());
            return metadata;
        }
        finally {
            recordStore.afterOperation();
        }
    }

    @Nullable
    private static Metadata resolveMetadata(NodeEngine nodeEngine, Object key, Object value) {
        InternalSerializationService ss = Util.getSerializationService((HazelcastInstance)nodeEngine.getHazelcastInstance());
        Metadata keyMetadata = SampleMetadataResolver.resolve(ss, key, true);
        Metadata valueMetadata = SampleMetadataResolver.resolve(ss, value, false);
        return keyMetadata != null && valueMetadata != null ? keyMetadata.merge(valueMetadata) : null;
    }

    private static final class GetAnyMetadataRunnable
    implements PartitionSpecificRunnable {
        public static final int TIMEOUT = 5;
        private final MapServiceContext context;
        private final int partitionId;
        private final RecordStore<?> recordStore;
        private final CompletableFuture<Metadata> result = new CompletableFuture();

        GetAnyMetadataRunnable(MapServiceContext context, String mapName, int partitionId) {
            this.context = context;
            this.partitionId = partitionId;
            this.recordStore = context.getExistingRecordStore(this.getPartitionId(), mapName);
        }

        public boolean hasRecordStore() {
            return this.recordStore != null;
        }

        public void run() {
            assert (!this.result.isDone()) : "This runnable can be executed once";
            this.result.complete(MetadataResolver.resolveFromContentsRecordStore(this.context.getNodeEngine(), this.recordStore));
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public Metadata getResult() {
            try {
                return this.result.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
            catch (ExecutionException | TimeoutException e) {
                throw new HazelcastSqlException("Cannot get sample data from map", (Throwable)e);
            }
        }
    }
}

