/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.SerializationServiceV1;
import com.hazelcast.internal.serialization.impl.portable.PortableContext;
import com.hazelcast.internal.util.collection.DefaultedMap;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.inject.PortableUpsertTargetDescriptor;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableId;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class MetadataPortableResolver
implements KvMetadataResolver {
    public static final DefaultedMap<FieldType, QueryDataType> PORTABLE_TO_SQL = new DefaultedMap(new EnumMap<FieldType, QueryDataType>(ImmutableMap.builder().put(FieldType.BOOLEAN, QueryDataType.BOOLEAN).put(FieldType.BYTE, QueryDataType.TINYINT).put(FieldType.SHORT, QueryDataType.SMALLINT).put(FieldType.INT, QueryDataType.INT).put(FieldType.LONG, QueryDataType.BIGINT).put(FieldType.FLOAT, QueryDataType.REAL).put(FieldType.DOUBLE, QueryDataType.DOUBLE).put(FieldType.DECIMAL, QueryDataType.DECIMAL).put(FieldType.CHAR, QueryDataType.VARCHAR_CHARACTER).put(FieldType.UTF, QueryDataType.VARCHAR).put(FieldType.TIME, QueryDataType.TIME).put(FieldType.DATE, QueryDataType.DATE).put(FieldType.TIMESTAMP, QueryDataType.TIMESTAMP).put(FieldType.TIMESTAMP_WITH_TIMEZONE, QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME).put(FieldType.PORTABLE, QueryDataType.OBJECT).build()), (Object)QueryDataType.OBJECT);
    static final MetadataPortableResolver INSTANCE = new MetadataPortableResolver();

    private MetadataPortableResolver() {
    }

    @Override
    public Stream<String> supportedFormats() {
        return Stream.of("portable");
    }

    @Override
    public Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        SerializationServiceV1 ss;
        Portable tempPortableObj;
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(userFields, isKey);
        PortableId portableId = MetadataPortableResolver.getPortableId(fieldsByPath, options, isKey);
        ClassDefinition classDefinition = serializationService.getPortableContext().lookupClassDefinition(portableId);
        if (userFields.isEmpty() && classDefinition == null && (tempPortableObj = (ss = (SerializationServiceV1)serializationService).getPortableSerializer().createNewPortableInstance(portableId.getFactoryId(), portableId.getClassId())) != null) {
            try {
                ss.getPortableContext().lookupOrRegisterClassDefinition(tempPortableObj);
            }
            catch (Exception e) {
                throw QueryException.error((String)"Cannot create mapping for Portable type. Please, provide the explicit definition for all columns.");
            }
            classDefinition = serializationService.getPortableContext().lookupClassDefinition(portableId);
        }
        return userFields.isEmpty() ? MetadataPortableResolver.resolveFields(isKey, classDefinition) : MetadataPortableResolver.resolveAndValidateFields(isKey, fieldsByPath, classDefinition);
    }

    private static Stream<MappingField> resolveFields(boolean isKey, ClassDefinition classDefinition) {
        if (classDefinition == null || classDefinition.getFieldCount() == 0) {
            String name2 = isKey ? QueryPath.KEY : QueryPath.VALUE;
            return Stream.of(new MappingField(name2, QueryDataType.OBJECT, name2));
        }
        return classDefinition.getFieldNames().stream().map(name -> {
            QueryPath path = new QueryPath((String)name, isKey);
            QueryDataType type = (QueryDataType)PORTABLE_TO_SQL.getOrDefault((Object)classDefinition.getFieldType(name));
            return new MappingField((String)name, type, path.toString());
        });
    }

    private static Stream<MappingField> resolveAndValidateFields(boolean isKey, Map<QueryPath, MappingField> fieldsByPath, @Nullable ClassDefinition classDefinition) {
        if (classDefinition == null) {
            return fieldsByPath.values().stream().peek(mappingField -> {
                QueryDataType type = mappingField.type();
                if (type.getTypeFamily().equals((Object)QueryDataTypeFamily.OBJECT)) {
                    throw QueryException.error((String)("Cannot derive Portable type for '" + String.valueOf((Object)type.getTypeFamily()) + "'"));
                }
            });
        }
        for (String name : classDefinition.getFieldNames()) {
            QueryPath path = new QueryPath(name, isKey);
            QueryDataType type = (QueryDataType)PORTABLE_TO_SQL.getOrDefault((Object)classDefinition.getFieldType(name));
            MappingField userField = fieldsByPath.get(path);
            if (userField == null || type.getTypeFamily().equals((Object)userField.type().getTypeFamily())) continue;
            throw QueryException.error((String)("Mismatch between declared and resolved type: " + userField.name()));
        }
        return fieldsByPath.values().stream();
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(resolvedFields, isKey);
        PortableId portableId = MetadataPortableResolver.getPortableId(fieldsByPath, options, isKey);
        ClassDefinition classDefinition = MetadataPortableResolver.resolveClassDefinition(portableId, KvMetadataResolver.getFields(fieldsByPath), serializationService.getPortableContext());
        ArrayList<TableField> fields = new ArrayList<TableField>();
        for (Map.Entry<QueryPath, MappingField> entry : fieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add(new MapTableField(name, type, false, path));
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields, QueryDataType.OBJECT);
        return new KvMetadata(fields, GenericQueryTargetDescriptor.DEFAULT, new PortableUpsertTargetDescriptor(classDefinition));
    }

    private static ClassDefinition resolveClassDefinition(PortableId portableId, Stream<KvMetadataResolver.Field> fields, PortableContext context) {
        ClassDefinition classDefinition = context.lookupClassDefinition(portableId);
        if (classDefinition != null) {
            return classDefinition;
        }
        return ((ClassDefinitionBuilder)Util.reduce((Object)new ClassDefinitionBuilder(portableId), fields, (schema, field) -> {
            switch (field.type().getTypeFamily()) {
                case BOOLEAN: {
                    return schema.addBooleanField(field.name());
                }
                case TINYINT: {
                    return schema.addByteField(field.name());
                }
                case SMALLINT: {
                    return schema.addShortField(field.name());
                }
                case INTEGER: {
                    return schema.addIntField(field.name());
                }
                case BIGINT: {
                    return schema.addLongField(field.name());
                }
                case REAL: {
                    return schema.addFloatField(field.name());
                }
                case DOUBLE: {
                    return schema.addDoubleField(field.name());
                }
                case DECIMAL: {
                    return schema.addDecimalField(field.name());
                }
                case VARCHAR: {
                    return schema.addStringField(field.name());
                }
                case TIME: {
                    return schema.addTimeField(field.name());
                }
                case DATE: {
                    return schema.addDateField(field.name());
                }
                case TIMESTAMP: {
                    return schema.addTimestampField(field.name());
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    return schema.addTimestampWithTimezoneField(field.name());
                }
            }
            return schema;
        })).build();
    }

    private static PortableId getPortableId(Map<QueryPath, MappingField> fields, Map<String, String> options, boolean isKey) {
        return KvMetadataResolver.getMetadata(fields).map(PortableId::new).orElseGet(() -> MetadataPortableResolver.portableId(options, isKey));
    }

    public static PortableId portableId(Map<String, String> options, boolean isKey) {
        String versionProperty;
        String classIdProperty;
        String factoryIdProperty = isKey ? "keyPortableFactoryId" : "valuePortableFactoryId";
        PortableId portableId = MetadataPortableResolver.portableId(options, factoryIdProperty, classIdProperty = isKey ? "keyPortableClassId" : "valuePortableClassId", versionProperty = isKey ? "keyPortableClassVersion" : "valuePortableClassVersion");
        if (portableId == null) {
            throw QueryException.error((String)String.format("%s Portable ID (%s, %s and optional %s) is required to create Portable-based mapping", isKey ? "Key" : "Value", factoryIdProperty, classIdProperty, versionProperty));
        }
        return portableId;
    }

    public static PortableId portableId(Map<String, String> options, String factoryIdProperty, String classIdProperty, String versionProperty) {
        Integer factoryId = Optional.ofNullable(options.get(factoryIdProperty)).map(Integer::parseInt).orElse(null);
        Integer classId = Optional.ofNullable(options.get(classIdProperty)).map(Integer::parseInt).orElse(null);
        int version = Optional.ofNullable(options.get(versionProperty)).map(Integer::parseInt).orElse(0);
        return factoryId != null && classId != null ? new PortableId(factoryId.intValue(), classId.intValue(), version) : null;
    }
}

