/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.join;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlConnector;
import com.hazelcast.jet.sql.impl.connector.jdbc.TypeResolver;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Function;

public class FullScanRowMapper
implements Function<ResultSet, JetSqlRow> {
    private final ExpressionEvalContext expressionEvalContext;
    private final TypeResolver typeResolver;
    private final List<FunctionEx<Object, ?>> converters;
    private final JetJoinInfo joinInfo;
    private final List<Expression<?>> projections;
    private final JetSqlRow leftRow;
    private Object[] values;
    private BiFunctionEx<ResultSet, Integer, ?>[] valueGetters;

    public FullScanRowMapper(ExpressionEvalContext expressionEvalContext, TypeResolver typeResolver, List<FunctionEx<Object, ?>> converters, List<Expression<?>> projections, JetJoinInfo joinInfo, JetSqlRow leftRow) {
        this.expressionEvalContext = expressionEvalContext;
        this.typeResolver = typeResolver;
        this.converters = converters;
        this.projections = projections;
        this.joinInfo = joinInfo;
        this.leftRow = leftRow;
    }

    @Override
    public JetSqlRow apply(ResultSet resultSet) {
        try {
            if (this.values == null) {
                this.values = FullScanRowMapper.createValueArray(resultSet);
            }
            this.fillValueArray(resultSet, this.values);
            JetSqlRow jetSqlRowFromDB = new JetSqlRow((SerializationService)this.expressionEvalContext.getSerializationService(), this.values);
            JetSqlRow joinedRow = ExpressionUtil.join(this.leftRow, jetSqlRowFromDB, this.joinInfo.nonEquiCondition(), this.expressionEvalContext);
            if (joinedRow != null) {
                return joinedRow;
            }
            if (!this.joinInfo.isInner()) {
                return this.createExtendedRow(this.leftRow);
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    protected static Object[] createValueArray(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        return new Object[columnCount];
    }

    protected void fillValueArray(ResultSet resultSet, Object[] values) throws SQLException {
        if (this.valueGetters == null) {
            this.valueGetters = JdbcSqlConnector.prepareValueGettersFromMetadata(this.typeResolver, resultSet, this.converters::get);
        }
        for (int index = 0; index < values.length; ++index) {
            values[index] = this.valueGetters[index].apply((Object)resultSet, (Object)(index + 1));
        }
    }

    protected JetSqlRow createExtendedRow(JetSqlRow leftRow) {
        return leftRow.extendedRow(this.projections.size());
    }
}

