/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.join;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.iterator.AutoCloseableIterator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;

public class FullScanResultSetIterator<T>
implements AutoCloseableIterator<T> {
    private final Connection connection;
    private final String sql;
    private final Function<ResultSet, T> rowMapper;
    private final Supplier<T> emptyResultSetMapper;
    private boolean hasNext;
    private boolean hasNextMethodCalled;
    private boolean iteratorClosed;
    private ResultSet resultSet;
    private PreparedStatement preparedStatement;
    private boolean callEmptyResultMapper = true;
    private T nextItem;

    public FullScanResultSetIterator(Connection connection, String sql, Function<ResultSet, T> rowMapper, Supplier<T> emptyResultSetMapper) {
        this.connection = connection;
        this.sql = sql;
        this.rowMapper = rowMapper;
        this.emptyResultSetMapper = emptyResultSetMapper;
    }

    public boolean hasNext() {
        try {
            if (this.iteratorClosed) {
                return false;
            }
            this.getNextItem();
            if (!this.hasNext) {
                this.close();
            }
            this.hasNextMethodCalled = true;
            return this.hasNext;
        }
        catch (SQLException sqlException) {
            this.close();
            throw ExceptionUtil.sneakyThrow((Throwable)sqlException);
        }
    }

    public T next() {
        try {
            if (this.iteratorClosed) {
                throw new NoSuchElementException();
            }
            if (!this.hasNextMethodCalled) {
                this.getNextItem();
            }
            if (!this.hasNext) {
                this.close();
                throw new NoSuchElementException();
            }
            this.hasNextMethodCalled = false;
            return this.nextItem;
        }
        catch (SQLException sqlException) {
            this.close();
            throw ExceptionUtil.sneakyThrow((Throwable)sqlException);
        }
    }

    private void lazyInit() throws SQLException {
        if (this.preparedStatement == null) {
            this.preparedStatement = this.connection.prepareStatement(this.sql);
            this.resultSet = this.preparedStatement.executeQuery();
        }
    }

    public void close() {
        if (!this.iteratorClosed) {
            this.iteratorClosed = true;
            IOUtil.closeResource((AutoCloseable)this.resultSet);
            IOUtil.closeResource((AutoCloseable)this.preparedStatement);
            IOUtil.closeResource((AutoCloseable)this.connection);
        }
    }

    private void getNextItem() throws SQLException {
        this.lazyInit();
        this.hasNext = this.getNextItemFromEither();
    }

    private boolean getNextItemFromEither() throws SQLException {
        while (this.resultSet.next()) {
            this.nextItem = this.rowMapper.apply(this.resultSet);
            if (this.nextItem == null) continue;
            this.callEmptyResultMapper = false;
            return true;
        }
        if (this.callEmptyResultMapper) {
            this.callEmptyResultMapper = false;
            this.nextItem = this.emptyResultSetMapper.get();
            return this.nextItem != null;
        }
        return false;
    }
}

