/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.ToResultSetFunction;
import com.hazelcast.jet.impl.connector.ReadJdbcP;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractJdbcSqlConnectorProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlConnector;
import com.hazelcast.jet.sql.impl.connector.jdbc.TypeResolver;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.impl.function.SecuredFunction;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SelectProcessorSupplier
extends AbstractJdbcSqlConnectorProcessorSupplier
implements ProcessorSupplier,
DataSerializable,
SecuredFunction {
    private String query;
    private int[] parameterPositions;
    private List<FunctionEx<Object, ?>> converters = new ArrayList();
    private transient ExpressionEvalContext evalContext;
    private volatile transient BiFunctionEx<ResultSet, Integer, ?>[] valueGetters;

    public SelectProcessorSupplier() {
    }

    public SelectProcessorSupplier(@Nonnull String dataConnectionName, @Nonnull String query, @Nonnull int[] parameterPositions, @Nonnull List<FunctionEx<Object, ?>> converters) {
        super(dataConnectionName);
        this.query = Objects.requireNonNull(query, "query must not be null");
        this.parameterPositions = Objects.requireNonNull(parameterPositions, "parameterPositions must not be null");
        this.converters = converters;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        super.init(context);
        this.evalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        assert (count == 1);
        ReadJdbcP processor = new ReadJdbcP((SupplierEx & Serializable)() -> this.dataConnection.getConnection(), (ToResultSetFunction & Serializable)(connection, parallelism, index) -> {
            TypeResolver typeResolver = JdbcSqlConnector.typeResolver(connection);
            PreparedStatement statement = connection.prepareStatement(this.query);
            List<Object> arguments = this.evalContext.getArguments();
            for (int j = 0; j < this.parameterPositions.length; ++j) {
                typeResolver.setObject(statement, arguments.get(this.parameterPositions[j]), j);
            }
            try {
                ResultSet rs = statement.executeQuery();
                this.valueGetters = JdbcSqlConnector.prepareValueGettersFromMetadata(typeResolver, rs, this.converters::get);
                return rs;
            }
            catch (SQLException e) {
                statement.close();
                throw e;
            }
        }, (FunctionEx & Serializable)rs -> {
            int columnCount = rs.getMetaData().getColumnCount();
            Object[] row = new Object[columnCount];
            for (int j = 0; j < columnCount; ++j) {
                Object value;
                row[j] = value = this.valueGetters[j].apply(rs, (Object)(j + 1));
            }
            return new JetSqlRow((SerializationService)this.evalContext.getSerializationService(), row);
        });
        return Collections.singleton(processor);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.dataConnectionName);
        out.writeString(this.query);
        out.writeIntArray(this.parameterPositions);
        out.writeObject(this.converters);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.dataConnectionName = in.readString();
        this.query = in.readString();
        this.parameterPositions = in.readIntArray();
        this.converters = (List)in.readObject();
    }
}

