/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.impl.AutoCloseableTraversers;
import com.hazelcast.jet.impl.util.AutoCloseableTraverser;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractJoinProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlConnector;
import com.hazelcast.jet.sql.impl.connector.jdbc.TypeResolver;
import com.hazelcast.jet.sql.impl.connector.jdbc.join.JoinPredicatePreparedStatementSetter;
import com.hazelcast.jet.sql.impl.connector.jdbc.join.JoinPredicateScanResultSetIterator;
import com.hazelcast.jet.sql.impl.connector.jdbc.join.JoinPredicateScanRowMapper;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.impl.function.SecuredFunction;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class JdbcJoinPredicateScanProcessorSupplier
extends AbstractJoinProcessorSupplier
implements DataSerializable,
SecuredFunction {
    public JdbcJoinPredicateScanProcessorSupplier() {
    }

    public JdbcJoinPredicateScanProcessorSupplier(@Nonnull String dataConnectionName, @Nonnull String query, List<FunctionEx<Object, ?>> converters, @Nonnull JetJoinInfo joinInfo, List<Expression<?>> projections) {
        super(dataConnectionName, query, converters, joinInfo, projections);
    }

    @Override
    protected AutoCloseableTraverser<JetSqlRow> joinRows(Iterable<JetSqlRow> leftRows) {
        ArrayList<JetSqlRow> leftRowsList = this.convertIterableToArrayList(leftRows);
        String unionAllSql = this.generateSql(leftRowsList);
        return AutoCloseableTraversers.traverseAutoCloseableIterator(this.joinUnionAll(leftRowsList, unionAllSql));
    }

    private <T> ArrayList<T> convertIterableToArrayList(Iterable<T> iterable) {
        Stream stream = StreamSupport.stream(iterable.spliterator(), false);
        return stream.collect(Collectors.toCollection(ArrayList::new));
    }

    private String generateSql(List<JetSqlRow> leftRowsList) {
        String delimiter = " UNION ALL ";
        Object sql = IntStream.range(0, leftRowsList.size()).mapToObj(i -> this.query.replaceFirst("replacerownumber", String.valueOf(i))).collect(Collectors.joining(delimiter));
        sql = (String)sql + " ORDER BY CONFIDENTIAL_ROWNUM";
        return sql;
    }

    private JoinPredicateScanResultSetIterator<JetSqlRow> joinUnionAll(List<JetSqlRow> leftRowsList, String unionAllSql) {
        Connection connection = this.dataConnection.getConnection();
        TypeResolver typeResolver = JdbcSqlConnector.typeResolver(connection);
        return new JoinPredicateScanResultSetIterator<JetSqlRow>(this.dataConnection.getConnection(), unionAllSql, new JoinPredicateScanRowMapper(this.expressionEvalContext, typeResolver, this.converters, this.projections, this.joinInfo, leftRowsList), new JoinPredicatePreparedStatementSetter(this.joinInfo, leftRowsList));
    }
}

