/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.AbstractSqlResult;
import com.hazelcast.sql.impl.CoreQueryUtils;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryResultProducer;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.SqlRowImpl;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SqlResultImpl
extends AbstractSqlResult {
    private final QueryId queryId;
    private final QueryResultProducer rootResultConsumer;
    private final SqlRowMetadata rowMetadata;
    private final boolean isInfiniteRows;
    private final int partitionArgumentIndex;
    private ResultIterator<SqlRow> iterator;

    SqlResultImpl(QueryId queryId, QueryResultProducer rootResultConsumer, SqlRowMetadata rowMetadata, boolean isInfiniteRows) {
        this.queryId = queryId;
        this.rootResultConsumer = rootResultConsumer;
        this.rowMetadata = rowMetadata;
        this.isInfiniteRows = isInfiniteRows;
        this.partitionArgumentIndex = -1;
    }

    SqlResultImpl(QueryId queryId, QueryResultProducer rootResultConsumer, SqlRowMetadata rowMetadata, boolean isInfiniteRows, int partitionArgumentIndex) {
        this.queryId = queryId;
        this.rootResultConsumer = rootResultConsumer;
        this.rowMetadata = rowMetadata;
        this.isInfiniteRows = isInfiniteRows;
        this.partitionArgumentIndex = partitionArgumentIndex;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public boolean isInfiniteRows() {
        return this.isInfiniteRows;
    }

    public int getPartitionArgumentIndex() {
        return this.partitionArgumentIndex;
    }

    @Nonnull
    public SqlRowMetadata getRowMetadata() {
        return this.rowMetadata;
    }

    @Nonnull
    public ResultIterator<SqlRow> iterator() {
        if (this.iterator == null) {
            this.iterator = new RowToSqlRowIterator(this.rootResultConsumer.iterator());
            return this.iterator;
        }
        throw new IllegalStateException("Iterator can be requested only once.");
    }

    public long updateCount() {
        return -1L;
    }

    public void close(@Nullable QueryException exception) {
        if (exception == null) {
            exception = QueryException.cancelledByUser();
        }
        this.rootResultConsumer.onError(exception);
    }

    private final class RowToSqlRowIterator
    implements ResultIterator<SqlRow> {
        private final ResultIterator<JetSqlRow> delegate;

        private RowToSqlRowIterator(ResultIterator<JetSqlRow> delegate) {
            this.delegate = delegate;
        }

        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (Exception e) {
                throw CoreQueryUtils.toPublicException((Throwable)e, (UUID)SqlResultImpl.this.queryId.getMemberId());
            }
        }

        public ResultIterator.HasNextResult hasNext(long timeout, TimeUnit timeUnit) {
            try {
                return this.delegate.hasNext(timeout, timeUnit);
            }
            catch (Exception e) {
                throw CoreQueryUtils.toPublicException((Throwable)e, (UUID)SqlResultImpl.this.queryId.getMemberId());
            }
        }

        public SqlRow next() {
            try {
                return new SqlRowImpl(SqlResultImpl.this.getRowMetadata(), (JetSqlRow)this.delegate.next());
            }
            catch (NoSuchElementException e) {
                throw e;
            }
            catch (Exception e) {
                throw CoreQueryUtils.toPublicException((Throwable)e, (UUID)SqlResultImpl.this.queryId.getMemberId());
            }
        }
    }
}

