/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.shaded.org.apache.calcite.avatica.util.Casing;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.Quoting;
import com.hazelcast.shaded.org.apache.calcite.config.CalciteConnectionConfig;
import com.hazelcast.shaded.org.apache.calcite.config.CalciteConnectionConfigImpl;
import com.hazelcast.shaded.org.apache.calcite.config.CalciteConnectionProperty;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParser;
import java.util.Properties;

public final class CalciteConfiguration {
    public static final CalciteConfiguration DEFAULT = new CalciteConfiguration(true, Casing.UNCHANGED, Casing.UNCHANGED, Quoting.DOUBLE_QUOTE);
    private final boolean caseSensitive;
    private final Casing unquotedCasing;
    private final Casing quotedCasing;
    private final Quoting quoting;

    private CalciteConfiguration(boolean caseSensitive, Casing unquotedCasing, Casing quotedCasing, Quoting quoting) {
        this.caseSensitive = caseSensitive;
        this.unquotedCasing = unquotedCasing;
        this.quotedCasing = quotedCasing;
        this.quoting = quoting;
    }

    public void toParserConfig(SqlParser.ConfigBuilder configBuilder) {
        configBuilder.setCaseSensitive(this.caseSensitive);
        configBuilder.setUnquotedCasing(this.unquotedCasing);
        configBuilder.setQuotedCasing(this.quotedCasing);
        configBuilder.setQuoting(this.quoting);
    }

    public CalciteConnectionConfig toConnectionConfig() {
        Properties connectionProperties = new Properties();
        connectionProperties.put(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), Boolean.toString(this.caseSensitive));
        connectionProperties.put(CalciteConnectionProperty.UNQUOTED_CASING.camelName(), this.unquotedCasing.toString());
        connectionProperties.put(CalciteConnectionProperty.QUOTED_CASING.camelName(), this.quotedCasing.toString());
        connectionProperties.put(CalciteConnectionProperty.QUOTING.camelName(), this.quoting.toString());
        connectionProperties.put(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), Boolean.toString(false));
        return new CalciteConnectionConfigImpl(connectionProperties);
    }
}

