/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.securestore.impl;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.JavaKeyStoreSecureStoreConfig;
import com.hazelcast.config.SecureStoreConfig;
import com.hazelcast.config.VaultSecureStoreConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.spi.impl.securestore.SecureStore;
import com.hazelcast.spi.impl.securestore.SecureStoreFactory;
import com.hazelcast.spi.impl.securestore.impl.JavaKeyStoreSecureStore;
import com.hazelcast.spi.impl.securestore.impl.VaultSecureStore;
import javax.annotation.Nonnull;

public class DefaultSecureStoreFactory
implements SecureStoreFactory {
    private final Node node;

    public DefaultSecureStoreFactory(@Nonnull Node node) {
        this.node = node;
    }

    @Override
    @Nonnull
    public SecureStore getSecureStore(@Nonnull SecureStoreConfig secureStoreConfig) {
        if (secureStoreConfig instanceof JavaKeyStoreSecureStoreConfig) {
            return new JavaKeyStoreSecureStore((JavaKeyStoreSecureStoreConfig)secureStoreConfig, this.node);
        }
        if (secureStoreConfig instanceof VaultSecureStoreConfig) {
            return new VaultSecureStore((VaultSecureStoreConfig)secureStoreConfig, this.node);
        }
        throw new InvalidConfigurationException("Unsupported Secure Store configuration type: " + String.valueOf(secureStoreConfig));
    }
}

