/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.permission.impl;

import com.hazelcast.security.permission.ClusterPermissionCollection;
import com.hazelcast.security.permission.impl.PermissionCollectionHolder;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;

public final class GrantAndDenyPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 1L;
    private final ClusterPermissionCollection collectionGrant;
    private volatile boolean allPermissionGrant;
    private final ClusterPermissionCollection collectionDeny;
    private volatile boolean allPermissionDeny;
    private final boolean permissionPriorityGrant;
    private final Class<? extends Permission> permClass;

    public GrantAndDenyPermissionCollection(Class<? extends Permission> permClass, boolean permissionPriorityGrant) {
        this.collectionGrant = new ClusterPermissionCollection(permClass);
        this.collectionDeny = new ClusterPermissionCollection(permClass);
        this.permissionPriorityGrant = permissionPriorityGrant;
        this.permClass = permClass;
    }

    @Override
    public void add(Permission permission) {
        throw new SecurityException(this.getClass().getSimpleName() + ": add(Permission) is not supported!");
    }

    public void addGranted(PermissionCollectionHolder pcHolder) {
        if (this.allPermissionGrant) {
            return;
        }
        if (pcHolder.isAllPermissions()) {
            this.allPermissionGrant = true;
            return;
        }
        this.add(this.collectionGrant, (PermissionCollection)pcHolder.getPermissions().get(this.permClass));
    }

    public void addDenied(PermissionCollectionHolder pcHolder) {
        if (this.allPermissionDeny) {
            return;
        }
        if (pcHolder.isAllPermissions()) {
            this.allPermissionDeny = true;
            return;
        }
        this.add(this.collectionDeny, (PermissionCollection)pcHolder.getPermissions().get(this.permClass));
    }

    private void add(ClusterPermissionCollection clusterPerms, PermissionCollection coll) {
        if (coll != null) {
            clusterPerms.add(coll);
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (this.permissionPriorityGrant) {
            return this.allPermissionGrant || this.collectionGrant.implies(permission) || !this.allPermissionDeny && !this.collectionDeny.implies(permission);
        }
        return !this.allPermissionDeny && !this.collectionDeny.implies(permission) && (this.allPermissionGrant || this.collectionGrant.implies(permission));
    }

    @Override
    public Enumeration<Permission> elements() {
        throw new SecurityException(this.getClass().getSimpleName() + ": Operation elements is not supported!");
    }

    @Override
    public String toString() {
        return "GrantAndDenyPermissionCollection [collectionGrant=" + String.valueOf(this.collectionGrant) + ", allPermissionGrant=" + this.allPermissionGrant + ", collectionDeny=" + String.valueOf(this.collectionDeny) + ", allPermissionDeny=" + this.allPermissionDeny + ", permissionPriorityGrant=" + this.permissionPriorityGrant + ", permClass=" + String.valueOf(this.permClass) + "]";
    }
}

