/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.loginimpl;

import com.hazelcast.security.CertificatesCallback;
import com.hazelcast.security.ClusterLoginModule;
import com.hazelcast.security.impl.LdapUtils;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class X509CertificateLoginModule
extends ClusterLoginModule {
    public static final String OPTION_ROLE_ATTRIBUTE = "roleAttribute";
    public static final String DEFAULT_ROLE_ATTRIBUTE = "cn";
    private String name;

    @Override
    public boolean onLogin() throws LoginException {
        CertificatesCallback cb = new CertificatesCallback();
        try {
            this.callbackHandler.handle(new Callback[]{cb});
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new FailedLoginException("Unable to retrieve Certificates. " + e.getMessage());
        }
        Certificate[] certs = cb.getCertificates();
        if (certs == null || certs.length == 0 || !(certs[0] instanceof X509Certificate)) {
            throw new FailedLoginException("No valid X.509 certificate found");
        }
        X509Certificate x509Cert = (X509Certificate)certs[0];
        String roleAttribute = this.getStringOption(OPTION_ROLE_ATTRIBUTE, DEFAULT_ROLE_ATTRIBUTE);
        this.name = x509Cert.getSubjectX500Principal().getName();
        if (!this.isSkipRole()) {
            try {
                LdapName ldapName = new LdapName(this.name);
                Collection<String> roles = LdapUtils.getAttributeValues(ldapName, roleAttribute);
                for (String role : roles) {
                    this.addRole(role);
                }
            }
            catch (NamingException e) {
                throw new FailedLoginException("Unable to parse Subject name from the X.509 certificate" + this.name);
            }
        }
        return true;
    }

    @Override
    protected String getName() {
        return this.name;
    }
}

