/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.EncryptionAtRestConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.JavaKeyStoreSecureStoreConfig;
import com.hazelcast.config.PersistenceConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecureStoreConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.security.KerberosAuthenticationConfig;
import com.hazelcast.config.security.LdapAuthenticationConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.config.security.SimpleAuthenticationConfig;
import com.hazelcast.config.security.UsernamePasswordIdentityConfig;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.SecretStrengthPolicy;
import com.hazelcast.security.WeakSecretException;
import com.hazelcast.security.impl.PasswordChecker;
import com.hazelcast.security.impl.WeakSecretError;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class WeakSecretsConfigChecker {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final Config config;
    private final PasswordChecker passwordChecker;

    public WeakSecretsConfigChecker(Config config) {
        this.config = config;
        SecretStrengthPolicy policy = null;
        try {
            policy = (SecretStrengthPolicy)ClassLoaderUtil.newInstance(WeakSecretsConfigChecker.class.getClassLoader(), System.getProperty("hazelcast.security.secret.strength.policy.class", "com.hazelcast.security.impl.DefaultSecretStrengthPolicy"));
        }
        catch (Exception e) {
            ExceptionUtil.rethrow(e);
        }
        this.passwordChecker = new PasswordChecker(policy);
    }

    public void evaluateAndReport(ILogger logger) {
        Map<String, EnumSet<WeakSecretError>> report = this.evaluate();
        if (!report.isEmpty()) {
            logger.warning(this.constructBanner(report));
            if (WeakSecretException.ENFORCED) {
                throw new WeakSecretException("Weak secrets found in configuration, check output above for more details.");
            }
        }
    }

    public Map<String, EnumSet<WeakSecretError>> evaluate() {
        SSLConfig sslConfig;
        PersistenceConfig persistenceConfig;
        HotRestartPersistenceConfig hotRestartPersistenceConfig;
        SymmetricEncryptionConfig sec;
        Map<String, EnumSet<WeakSecretError>> results = this.passwordChecker.getResults();
        if (!results.isEmpty()) {
            return results;
        }
        SecurityConfig securityConfig = this.config.getSecurityConfig();
        if (securityConfig != null && securityConfig.isEnabled()) {
            this.checkRealmsPasswords(securityConfig.getRealmConfigs());
        }
        if ((sec = ConfigAccessor.getActiveMemberNetworkConfig(this.config).getSymmetricEncryptionConfig()) != null && sec.isEnabled()) {
            this.passwordChecker.checkPassword("Symmetric Encryption Password", sec.getPassword());
        }
        if ((hotRestartPersistenceConfig = this.config.getHotRestartPersistenceConfig()).isEnabled()) {
            this.checkEncryptionAtRestSecrets("Hot Restart", hotRestartPersistenceConfig.getEncryptionAtRestConfig());
        }
        if ((persistenceConfig = this.config.getPersistenceConfig()) != null && persistenceConfig.isEnabled()) {
            this.checkEncryptionAtRestSecrets("Persistence", persistenceConfig.getEncryptionAtRestConfig());
        }
        if ((sslConfig = ConfigAccessor.getActiveMemberNetworkConfig(this.config).getSSLConfig()) != null && sslConfig.isEnabled() && sslConfig.getProperties() != null) {
            this.checkSSLConfigPasswords(sslConfig.getProperties());
        }
        return results;
    }

    private void checkSSLConfigPasswords(Properties sslProperties) {
        for (String key : sslProperties.stringPropertyNames()) {
            if (!key.toLowerCase(Locale.US).contains("password")) continue;
            this.passwordChecker.checkPassword("SSLConfig property[" + key + "]", sslProperties.getProperty(key));
        }
    }

    private void checkEncryptionAtRestSecrets(String header, EncryptionAtRestConfig encryptionAtRestConfig) {
        JavaKeyStoreSecureStoreConfig javaKeyStoreSecureStoreConfig;
        String javaKeyStorePassword;
        if (encryptionAtRestConfig == null || !encryptionAtRestConfig.isEnabled()) {
            return;
        }
        SecureStoreConfig secureStoreConfig = encryptionAtRestConfig.getSecureStoreConfig();
        if (secureStoreConfig instanceof JavaKeyStoreSecureStoreConfig && (javaKeyStorePassword = (javaKeyStoreSecureStoreConfig = (JavaKeyStoreSecureStoreConfig)secureStoreConfig).getPassword()) != null) {
            this.passwordChecker.checkPassword(header + " Encryption Java KeyStore password", javaKeyStorePassword);
        }
    }

    private void checkRealmsPasswords(Map<String, RealmConfig> realms) {
        if (realms == null) {
            return;
        }
        for (Map.Entry<String, RealmConfig> entry : realms.entrySet()) {
            SimpleAuthenticationConfig simpleAuthn;
            UsernamePasswordIdentityConfig identityCfg = entry.getValue().getUsernamePasswordIdentityConfig();
            String realmName = entry.getKey();
            if (identityCfg != null) {
                this.passwordChecker.checkPassword("Identity password in Security realm " + realmName, identityCfg.getPassword());
            }
            if ((simpleAuthn = entry.getValue().getSimpleAuthenticationConfig()) != null) {
                for (String user : simpleAuthn.getUsernames()) {
                    this.passwordChecker.checkPassword("Simple authentication password for user '" + user + "' in Security realm " + realmName, simpleAuthn.getPassword(user));
                }
            }
            LdapAuthenticationConfig ldapAuthn = entry.getValue().getLdapAuthenticationConfig();
            this.checkLdapAuthentication(realmName, ldapAuthn);
            KerberosAuthenticationConfig krbAuthn = entry.getValue().getKerberosAuthenticationConfig();
            if (krbAuthn == null) continue;
            this.checkLdapAuthentication(realmName, krbAuthn.getLdapAuthenticationConfig());
        }
    }

    private void checkLdapAuthentication(String realmName, LdapAuthenticationConfig ldapAuthn) {
        if (ldapAuthn != null && ldapAuthn.getSystemUserPassword() != null) {
            this.passwordChecker.checkPassword("LDAP authentication system user password in Security realm " + realmName, ldapAuthn.getSystemUserPassword());
        }
    }

    private String constructBanner(Map<String, EnumSet<WeakSecretError>> report) {
        StringBuilder banner = new StringBuilder();
        banner.append(LINE_SEP).append("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ SECURITY WARNING @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@").append(LINE_SEP);
        for (Map.Entry<String, EnumSet<WeakSecretError>> weakSecret : report.entrySet()) {
            banner.append(WeakSecretException.formatMessage(weakSecret.getKey(), weakSecret.getValue())).append(LINE_SEP).append(LINE_SEP);
        }
        banner.append("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        return banner.toString();
    }
}

