/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.security.SecretStrengthPolicy;
import com.hazelcast.security.WeakSecretException;
import com.hazelcast.security.impl.WeakSecretError;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PasswordChecker {
    private final SecretStrengthPolicy policy;
    private final Map<String, EnumSet<WeakSecretError>> results = new HashMap<String, EnumSet<WeakSecretError>>();

    public PasswordChecker(SecretStrengthPolicy policy) {
        this.policy = Objects.requireNonNull(policy);
    }

    public boolean checkPassword(String label, String password) {
        try {
            this.policy.validate(label, password);
            return true;
        }
        catch (WeakSecretException ex) {
            EnumSet<WeakSecretError> pwdWeaknesses = ex.getWeaknesses();
            this.results.compute(label, (k, v) -> {
                if (v != null) {
                    pwdWeaknesses.addAll((Collection<WeakSecretError>)v);
                }
                return pwdWeaknesses;
            });
            return false;
        }
    }

    @Nonnull
    public Map<String, EnumSet<WeakSecretError>> getResults() {
        return this.results;
    }
}

