/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.security.ConfigCallback;
import com.hazelcast.security.HazelcastInstanceCallback;
import com.hazelcast.security.LoggingServiceCallback;
import com.hazelcast.security.RealmConfigCallback;
import com.hazelcast.security.SecurityContextCallback;
import com.hazelcast.security.TokenDeserializerCallback;
import com.hazelcast.security.impl.PropertyCallback;
import com.hazelcast.security.impl.TokenDeserializerImpl;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class NodeCallbackHandler
implements CallbackHandler {
    public static final String PROPERTY_CURRENT_SECURITY_REALM = "currentRealm";
    private final Node node;
    private final Properties properties;

    protected NodeCallbackHandler(Builder builder) {
        this.node = builder.node;
        this.properties = builder.properties;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            this.handleCallback(cb);
        }
    }

    protected void handleCallback(Callback cb) throws UnsupportedCallbackException {
        if (cb instanceof ConfigCallback) {
            ((ConfigCallback)cb).setConfig(this.node != null ? this.node.getConfig() : null);
        } else if (cb instanceof RealmConfigCallback) {
            RealmConfigCallback realmCb = (RealmConfigCallback)cb;
            RealmConfig realmCfg = null;
            if (this.node != null && this.node.getConfig().getSecurityConfig() != null) {
                realmCfg = this.node.getConfig().getSecurityConfig().getRealmConfig(realmCb.getRealmName());
            }
            realmCb.setRealmConfig(realmCfg);
        } else if (cb instanceof TokenDeserializerCallback) {
            ((TokenDeserializerCallback)cb).setTokenDeserializer(new TokenDeserializerImpl(this.node.getSerializationService()));
        } else if (cb instanceof LoggingServiceCallback) {
            ((LoggingServiceCallback)cb).setLoggingService(this.node.getLoggingService());
        } else if (cb instanceof HazelcastInstanceCallback) {
            ((HazelcastInstanceCallback)cb).setHazelcastInstance(this.node.hazelcastInstance);
        } else if (cb instanceof SecurityContextCallback) {
            ((SecurityContextCallback)cb).setSecurityContext(this.node.securityContext);
        } else if (cb instanceof PropertyCallback) {
            PropertyCallback pcb = (PropertyCallback)cb;
            pcb.setPropertyValue(this.properties.getProperty(pcb.getPropertyName()));
        } else {
            throw new UnsupportedCallbackException(cb);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        private Node node;
        private Properties properties = new Properties();

        protected Builder() {
        }

        public T withNode(Node node) {
            this.node = node;
            return this.self();
        }

        public T withProperty(String propertyName, String value) {
            if (value != null) {
                this.properties.setProperty(propertyName, value);
            } else {
                this.properties.remove(propertyName);
            }
            return this.self();
        }

        public NodeCallbackHandler build() {
            return new NodeCallbackHandler(this);
        }

        protected T self() {
            return (T)this;
        }
    }
}

