/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.security.ClusterEndpointPrincipal;
import com.hazelcast.security.ClusterRolePrincipal;
import com.hazelcast.security.IPermissionPolicy;
import com.hazelcast.security.impl.SecurityUtil;
import com.hazelcast.security.permission.AllPermissions;
import com.hazelcast.security.permission.ClusterPermission;
import com.hazelcast.security.permission.ClusterPermissionCollection;
import com.hazelcast.security.permission.DenyAllPermissionCollection;
import com.hazelcast.security.permission.impl.GrantAndDenyPermissionCollection;
import com.hazelcast.security.permission.impl.PermissionCollectionHolder;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.security.auth.Subject;

public class DefaultPermissionPolicy
implements IPermissionPolicy {
    private static final String REGEX_ANY_ENDPOINT = "*.*.*.*";
    private static final String REGEX_ANY_ENDPOINT_IPV6 = "*:*:*:*:*:*:*:*";
    private static final String REGEX_ANY_PRINCIPAL = "*";
    private static final ILogger LOGGER = Logger.getLogger(DefaultPermissionPolicy.class.getName());
    private static final PermissionCollection DENY_ALL = new DenyAllPermissionCollection();
    private static final PermissionCollection ALLOW_ALL = new AllPermissions.AllPermissionsCollection(true);
    private static final String PRINCIPAL_STRING_SEP = ",";
    private static final Collection<String> ALL_ENDPOINTS = Collections.unmodifiableCollection(Arrays.asList("*.*.*.*", "*:*:*:*:*:*:*:*"));
    final ConcurrentMap<PrincipalKey, PermissionCollection> configPermissionsGrant = new ConcurrentHashMap<PrincipalKey, PermissionCollection>();
    final ConcurrentMap<PrincipalKey, PermissionCollection> configPermissionsDeny = new ConcurrentHashMap<PrincipalKey, PermissionCollection>();
    final ConcurrentMap<String, PrincipalPermissionsHolder> principalPermissions = new ConcurrentHashMap<String, PrincipalPermissionsHolder>();
    final Object configUpdateMutex = new Object();
    volatile ConfigPatternMatcher configPatternMatcher;
    private volatile boolean permissionPriorityGrant;

    @Override
    public void configure(Config config, Properties properties) {
        LOGGER.log(Level.FINEST, "Configuring and initializing policy.");
        this.configPatternMatcher = config.getConfigPatternMatcher();
        this.permissionPriorityGrant = config.getSecurityConfig().isPermissionPriorityGrant();
        this.loadPermissionConfig(config.getSecurityConfig().getClientPermissionConfigs());
    }

    private void loadPermissionConfig(Set<PermissionConfig> configuredPermissionConfigs) {
        HashSet<PermissionConfig> permissionConfigs = new HashSet<PermissionConfig>(configuredPermissionConfigs);
        Set<PermissionConfig> impliedPermissionConfigs = this.createImpliedRingBufferPermissionConfigs(configuredPermissionConfigs);
        permissionConfigs.addAll(impliedPermissionConfigs);
        for (PermissionConfig permCfg : permissionConfigs) {
            String[] stringArray;
            ClusterPermission permission = SecurityUtil.createPermission(permCfg);
            if (permCfg.getPrincipal() != null) {
                stringArray = permCfg.getPrincipal().split(PRINCIPAL_STRING_SEP);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = REGEX_ANY_PRINCIPAL;
            }
            String[] principals = stringArray;
            Collection<String> endpoints = permCfg.getEndpoints();
            if (endpoints.isEmpty()) {
                endpoints = ALL_ENDPOINTS;
            }
            for (String endpoint : endpoints) {
                for (String principal : principals) {
                    PrincipalKey key = new PrincipalKey(principal, endpoint);
                    this.getOrCreateClusterPermissionCollection(key, permCfg.isDeny()).add(permission);
                }
            }
        }
    }

    private PermissionCollection getOrCreateClusterPermissionCollection(PrincipalKey key, boolean deny) {
        ConcurrentMap<PrincipalKey, PermissionCollection> configPermissions = deny ? this.configPermissionsDeny : this.configPermissionsGrant;
        PermissionCollection coll = (PermissionCollection)configPermissions.get(key);
        if (coll == null) {
            coll = new ClusterPermissionCollection();
            configPermissions.put(key, coll);
        }
        return coll;
    }

    private Set<PermissionConfig> createImpliedRingBufferPermissionConfigs(Set<PermissionConfig> permissionConfigs) {
        HashSet<PermissionConfig> impliedRingBufferPermissionConfigs = new HashSet<PermissionConfig>();
        for (PermissionConfig permissionConfig : permissionConfigs) {
            if (!permissionConfig.getType().equals((Object)PermissionConfig.PermissionType.RELIABLE_TOPIC) || permissionConfig.isDeny()) continue;
            PermissionConfig impliedRingBufferPermissions = new PermissionConfig();
            impliedRingBufferPermissions.setName("_hz_rb_" + permissionConfig.getName());
            impliedRingBufferPermissions.setType(PermissionConfig.PermissionType.RING_BUFFER);
            impliedRingBufferPermissions.setEndpoints(permissionConfig.getEndpoints());
            impliedRingBufferPermissions.setDeny(permissionConfig.isDeny());
            Set<String> actions = permissionConfig.getActions();
            HashSet<String> impliedActions = new HashSet<String>();
            for (String action : actions) {
                if ("create".equals(action)) {
                    impliedActions.add(action);
                    continue;
                }
                if ("destroy".equals(action)) {
                    impliedActions.add(action);
                    continue;
                }
                if ("publish".equals(action)) {
                    impliedActions.add("put");
                    continue;
                }
                if (!"listen".equals(action)) continue;
                impliedActions.add("read");
            }
            impliedRingBufferPermissions.setActions(impliedActions);
            impliedRingBufferPermissionConfigs.add(impliedRingBufferPermissions);
        }
        return impliedRingBufferPermissionConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(Subject subject, Class<? extends Permission> type) {
        Set<ClusterRolePrincipal> principals = subject.getPrincipals(ClusterRolePrincipal.class);
        Set<ClusterEndpointPrincipal> endpointPrincipals = subject.getPrincipals(ClusterEndpointPrincipal.class);
        if (principals.isEmpty()) {
            return this.permissionPriorityGrant ? ALLOW_ALL : DENY_ALL;
        }
        Iterator<ClusterEndpointPrincipal> endpointIterator = endpointPrincipals.iterator();
        String endpoint = endpointIterator.hasNext() ? endpointIterator.next().getName() : null;
        GrantAndDenyPermissionCollection gradeCollection = new GrantAndDenyPermissionCollection(type, this.permissionPriorityGrant);
        for (ClusterRolePrincipal principal : principals) {
            Object roleEndpointKey;
            PrincipalPermissionsHolder permissionsHolder;
            do {
                this.ensurePrincipalPermissions(principal, endpoint);
            } while ((permissionsHolder = (PrincipalPermissionsHolder)this.principalPermissions.get(roleEndpointKey = DefaultPermissionPolicy.getRoleEndpointKey(principal.getName(), endpoint))) == null);
            if (!permissionsHolder.prepared) {
                try {
                    roleEndpointKey = permissionsHolder;
                    synchronized (roleEndpointKey) {
                        while (!permissionsHolder.prepared) {
                            permissionsHolder.wait();
                        }
                    }
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    throw new HazelcastException("Interrupted while waiting for the permissions holder to get prepared");
                }
            }
            if (this.permissionPriorityGrant && permissionsHolder.granted.isAllPermissions()) {
                return ALLOW_ALL;
            }
            if (!this.permissionPriorityGrant && permissionsHolder.denied.isAllPermissions()) {
                return DENY_ALL;
            }
            gradeCollection.addGranted(permissionsHolder.granted);
            gradeCollection.addDenied(permissionsHolder.denied);
        }
        return gradeCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshPermissions(Set<PermissionConfig> updatedPermissionConfigs) {
        Object object = this.configUpdateMutex;
        synchronized (object) {
            this.configPermissionsGrant.clear();
            this.configPermissionsDeny.clear();
            this.loadPermissionConfig(updatedPermissionConfigs);
            this.principalPermissions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensurePrincipalPermissions(ClusterRolePrincipal principal, String endpoint) {
        if (principal == null) {
            return;
        }
        String name = principal.getName();
        String roleEndpointKey = DefaultPermissionPolicy.getRoleEndpointKey(name, endpoint);
        if (this.principalPermissions.containsKey(roleEndpointKey)) {
            return;
        }
        PrincipalPermissionsHolder permissionsHolder = new PrincipalPermissionsHolder();
        if (this.principalPermissions.putIfAbsent(roleEndpointKey, permissionsHolder) != null) {
            return;
        }
        try {
            LOGGER.log(Level.FINEST, "Preparing permissions for: " + roleEndpointKey);
            ClusterPermissionCollection matchingPermissionsGrant = new ClusterPermissionCollection();
            ClusterPermissionCollection matchingPermissionsDeny = new ClusterPermissionCollection();
            Object object = this.configUpdateMutex;
            synchronized (object) {
                this.loadMatchingPermissions(endpoint, name, matchingPermissionsGrant, this.configPermissionsGrant);
                this.loadMatchingPermissions(endpoint, name, matchingPermissionsDeny, this.configPermissionsDeny);
            }
            this.fillCollection(permissionsHolder.granted, matchingPermissionsGrant.getPermissions());
            this.fillCollection(permissionsHolder.denied, matchingPermissionsDeny.getPermissions());
        }
        finally {
            PrincipalPermissionsHolder principalPermissionsHolder = permissionsHolder;
            synchronized (principalPermissionsHolder) {
                permissionsHolder.prepared = true;
                permissionsHolder.notifyAll();
            }
        }
    }

    private void fillCollection(PermissionCollectionHolder holder, Set<Permission> permissions) {
        for (Permission perm : permissions) {
            if (perm instanceof AllPermissions) {
                holder.setAllPermission();
                return;
            }
            Class<?> type = perm.getClass();
            ClusterPermissionCollection coll = (ClusterPermissionCollection)holder.getPermissions().get(type);
            if (coll == null) {
                coll = new ClusterPermissionCollection(type);
                holder.getPermissions().put(type, coll);
            }
            coll.add(perm);
        }
        LOGGER.log(Level.FINEST, "Compacting permissions");
        for (ClusterPermissionCollection coll : holder.getPermissions().values()) {
            coll.compact();
        }
    }

    private void loadMatchingPermissions(String endpoint, String name, ClusterPermissionCollection matchingPermissionsCollection, ConcurrentMap<PrincipalKey, PermissionCollection> configPermissions) {
        for (Map.Entry e : configPermissions.entrySet()) {
            PrincipalKey key = (PrincipalKey)e.getKey();
            if (!this.nameMatches(name, key.principal) || !this.endpointMatches(endpoint, key.endpoint)) continue;
            matchingPermissionsCollection.add((PermissionCollection)e.getValue());
        }
    }

    private boolean endpointMatches(String endpoint, String pattern) {
        if (endpoint == null) {
            return REGEX_ANY_ENDPOINT.equals(pattern);
        }
        return SecurityUtil.addressMatches(endpoint, pattern);
    }

    private boolean nameMatches(String name, String pattern) {
        if (name == null) {
            return REGEX_ANY_PRINCIPAL.equals(pattern);
        }
        if (name.equals(pattern)) {
            return true;
        }
        Set<String> patterns = Collections.singleton(pattern);
        return this.configPatternMatcher.matches(patterns, name) != null;
    }

    @Override
    public void destroy() {
        this.principalPermissions.clear();
        this.configPermissionsGrant.clear();
        this.configPermissionsDeny.clear();
    }

    private static String getRoleEndpointKey(String roleName, String endpoint) {
        return roleName + "@" + (endpoint != null ? endpoint : "");
    }

    private static class PrincipalKey {
        final String principal;
        final String endpoint;

        PrincipalKey(String principal, String endpoint) {
            this.principal = principal;
            this.endpoint = endpoint;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
            result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PrincipalKey other = (PrincipalKey)obj;
            return (this.endpoint != null ? this.endpoint.equals(other.endpoint) : other.endpoint == null) && (this.principal != null ? this.principal.equals(other.principal) : other.principal == null);
        }
    }

    private class PrincipalPermissionsHolder {
        volatile boolean prepared;
        final PermissionCollectionHolder granted = new PermissionCollectionHolder();
        final PermissionCollectionHolder denied = new PermissionCollectionHolder();

        private PrincipalPermissionsHolder() {
        }
    }
}

