/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.CertificatesCallback;
import com.hazelcast.security.ClusterNameCallback;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.CredentialsCallback;
import com.hazelcast.security.EndpointCallback;
import com.hazelcast.security.PasswordCredentials;
import com.hazelcast.security.impl.NodeCallbackHandler;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ClusterCallbackHandler
extends NodeCallbackHandler {
    private final String clusterName;
    private final Credentials credentials;
    private final Connection connection;
    private final InetAddress remoteAddress;

    private ClusterCallbackHandler(Builder builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.credentials = Objects.requireNonNull(builder.credentials, "Credentials have to be provided.");
        this.connection = builder.connection;
        this.remoteAddress = builder.remoteAddress;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            this.handleCallback(cb);
        }
    }

    @Override
    protected void handleCallback(Callback cb) throws UnsupportedCallbackException {
        if (cb instanceof NameCallback) {
            ((NameCallback)cb).setName(this.credentials.getName());
        } else if (cb instanceof PasswordCallback) {
            this.handlePasswordCallback((PasswordCallback)cb);
        } else if (cb instanceof CredentialsCallback) {
            ((CredentialsCallback)cb).setCredentials(this.credentials);
        } else if (cb instanceof EndpointCallback) {
            this.handleEndpointCallback((EndpointCallback)cb);
        } else if (cb instanceof CertificatesCallback) {
            Certificate[] certificates = null;
            if (this.connection != null) {
                certificates = (Certificate[])this.connection.attributeMap().get(Certificate.class);
            }
            ((CertificatesCallback)cb).setCertificates(certificates);
        } else if (cb instanceof ClusterNameCallback) {
            ((ClusterNameCallback)cb).setClusterName(this.clusterName);
        } else {
            super.handleCallback(cb);
        }
    }

    private void handleEndpointCallback(EndpointCallback cb) {
        InetAddress tmpAddress = this.remoteAddress;
        if (tmpAddress == null && this.connection != null) {
            tmpAddress = this.connection.getInetAddress();
        }
        if (tmpAddress != null) {
            cb.setEndpoint(tmpAddress.getHostAddress());
        }
    }

    private void handlePasswordCallback(PasswordCallback cb) {
        char[] password = null;
        if (this.credentials instanceof PasswordCredentials) {
            PasswordCredentials passwordCredentials = (PasswordCredentials)this.credentials;
            String pwdStr = passwordCredentials.getPassword();
            password = pwdStr == null ? null : pwdStr.toCharArray();
        }
        cb.setPassword(password);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends NodeCallbackHandler.Builder<Builder> {
        private String clusterName;
        private Credentials credentials;
        private Connection connection;
        private InetAddress remoteAddress;

        private Builder() {
        }

        public Builder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder withCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder withConnection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public Builder withRemoteAddress(InetAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        @Override
        public ClusterCallbackHandler build() {
            return new ClusterCallbackHandler(this);
        }
    }
}

