/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.bplustree.TStoreAllocator;
import com.hazelcast.internal.bplustree.TStoreBTreeCompactor;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.tstore.compaction.IndexPartitionCompactorStep;
import com.hazelcast.internal.tstore.compaction.LogBasedCompactor;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.recordstore.CompactionAwareStorage;
import com.hazelcast.query.impl.HDBPlusTreeIndex;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class TSBPlusTreeIndex<T extends QueryableEntry>
extends HDBPlusTreeIndex<T>
implements CompactionAwareStorage {
    private final Step partitionCompactorStep;
    private final TStoreAllocator tstoreAllocator;
    private volatile LogBasedCompactor partitionCompactor;

    TSBPlusTreeIndex(EnterpriseSerializationService ess, MemoryAllocator keyAllocator, MemoryAllocator btreeAllocator, MapEntryFactory<T> entryFactory, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, int nodeSize, EntrySlotPayload entrySlotPayload, String indexName) {
        super(ess, keyAllocator, btreeAllocator, entryFactory, keyComparator, keyAccessor, nodeSize, entrySlotPayload, true);
        this.tstoreAllocator = (TStoreAllocator)btreeAllocator;
        this.partitionCompactorStep = new IndexPartitionCompactorStep(indexName);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.tstoreAllocator.dispose();
    }

    @Override
    @Nullable
    public LogBasedCompactor getPartitionCompactorOrNull() {
        return this.partitionCompactor;
    }

    @Override
    public void setPartitionCompactor(LogBasedCompactor partitionCompactor) {
        this.partitionCompactor = partitionCompactor;
    }

    @Override
    public LogBasedCompactor newPartitionCompactor(int segmentNo) {
        TStoreBTreeCompactor.Dependencies dependencies = this.recordMap.getDependencies();
        return this.tstoreAllocator.newPartitionCompactor(segmentNo, dependencies);
    }

    public HybridLog getHybridLog() {
        return this.tstoreAllocator.getHybridLog();
    }

    @Override
    public void collectCustomSteps(Consumer<Step> steps) {
        steps.accept(this.partitionCompactorStep);
    }
}

