/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.BaseIndexStore;
import com.hazelcast.query.impl.BaseSingleValueIndexStore;
import com.hazelcast.query.impl.Comparables;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.CompositeValue;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexKeyEntries;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class OrderedIndexStore
extends BaseSingleValueIndexStore {
    public static final Comparator<Data> DATA_COMPARATOR = new DataComparator();
    public static final Comparator<Comparable> SPECIAL_AWARE_COMPARATOR = (left, right) -> {
        if (right == AbstractIndex.NULL) {
            return -AbstractIndex.NULL.compareTo(left);
        }
        if (right == CompositeValue.POSITIVE_INFINITY) {
            return -CompositeValue.POSITIVE_INFINITY.compareTo(left);
        }
        if (left == null && right == null) {
            return 0;
        }
        if (left != null && right != null) {
            return Comparables.compare(left, right);
        }
        if (left == null) {
            return -1;
        }
        return 1;
    };
    private final ConcurrentSkipListMap<Comparable, NavigableMap<Data, QueryableEntry>> recordMap = new ConcurrentSkipListMap(SPECIAL_AWARE_COMPARATOR);
    private final BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> addFunctor;
    private final BaseIndexStore.IndexFunctor<Comparable, Data> removeFunctor;

    public OrderedIndexStore(IndexCopyBehavior copyOn) {
        super(copyOn, true);
        assert (copyOn != null);
        if (copyOn == IndexCopyBehavior.COPY_ON_WRITE) {
            this.addFunctor = new CopyOnWriteAddFunctor();
            this.removeFunctor = new CopyOnWriteRemoveFunctor();
        } else {
            this.addFunctor = new AddFunctor();
            this.removeFunctor = new RemoveFunctor();
        }
    }

    @Override
    Object insertInternal(Comparable value, QueryableEntry record) {
        return this.addFunctor.invoke(value, record);
    }

    @Override
    Object removeInternal(Comparable value, Data recordKey) {
        return this.removeFunctor.invoke(value, recordKey);
    }

    @Override
    public Comparable canonicalizeQueryArgumentScalar(Comparable value) {
        return Comparables.canonicalizeForHashLookup(value);
    }

    @Override
    public Comparable canonicalizeScalarForStorage(Comparable value) {
        return value;
    }

    @Override
    public void clear() {
        this.takeWriteLock();
        try {
            this.recordMap.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public boolean isEvaluateOnly() {
        return false;
    }

    @Override
    public boolean canEvaluate(Class<? extends Predicate> predicateClass) {
        return false;
    }

    @Override
    public Set<QueryableEntry> evaluate(Predicate predicate, TypeConverter converter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(boolean descending) {
        return new IteratorFromBatch(this.getSqlRecordIteratorBatch(descending));
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(@Nonnull Comparable value) {
        return new IteratorFromBatch(this.getSqlRecordIteratorBatch(value, false));
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparison comparison, Comparable searchedValue, boolean descending) {
        return new IteratorFromBatch(this.getSqlRecordIteratorBatch(comparison, searchedValue, descending));
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        return new IteratorFromBatch(this.getSqlRecordIteratorBatch(from, fromInclusive, to, toInclusive, descending));
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(@Nonnull Comparable value, boolean descending) {
        return this.getSqlRecordIteratorBatch(value, descending, null);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(@Nonnull Comparable value, boolean descending, Data lastEntryKeyData) {
        NavigableMap<Data, QueryableEntry> entries = this.recordMap.get(value);
        if (entries == null) {
            return Collections.emptyIterator();
        }
        NavigableMap<Data, QueryableEntry> navigableMap = entries = descending ? entries.descendingMap() : entries;
        if (lastEntryKeyData != null) {
            entries = entries.tailMap(lastEntryKeyData, false);
        }
        return Stream.of(new IndexKeyEntries(value, entries.values().iterator())).iterator();
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(boolean descending) {
        if (descending) {
            return this.recordMap.descendingMap().entrySet().stream().map(es -> new IndexKeyEntries((Comparable)es.getKey(), ((NavigableMap)es.getValue()).descendingMap().values().iterator())).iterator();
        }
        return this.recordMap.entrySet().stream().map(es -> new IndexKeyEntries((Comparable)es.getKey(), ((NavigableMap)es.getValue()).values().iterator())).iterator();
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(@Nonnull Comparison comparison, @Nonnull Comparable searchedValue, boolean descending) {
        return this.getSqlRecordIteratorBatch(comparison, searchedValue, descending, null);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(@Nonnull Comparison comparison, @Nonnull Comparable searchedValue, boolean descending, Data lastEntryKeyData) {
        switch (comparison) {
            case LESS: {
                return this.getSqlRecordIteratorBatch(AbstractIndex.NULL, false, searchedValue, false, descending, lastEntryKeyData);
            }
            case LESS_OR_EQUAL: {
                return this.getSqlRecordIteratorBatch(AbstractIndex.NULL, false, searchedValue, true, descending, lastEntryKeyData);
            }
            case GREATER: {
                return this.getSqlRecordIteratorBatch(searchedValue, false, CompositeValue.POSITIVE_INFINITY, true, descending, lastEntryKeyData);
            }
            case GREATER_OR_EQUAL: {
                return this.getSqlRecordIteratorBatch(searchedValue, true, CompositeValue.POSITIVE_INFINITY, true, descending, lastEntryKeyData);
            }
        }
        throw new IllegalArgumentException("Unrecognized comparison: " + String.valueOf((Object)comparison));
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(@Nonnull Comparable from, boolean fromInclusive, @Nonnull Comparable to, boolean toInclusive, boolean descending) {
        return this.getSqlRecordIteratorBatch(from, fromInclusive, to, toInclusive, descending, null);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(@Nonnull Comparable from, boolean fromInclusive, @Nonnull Comparable to, boolean toInclusive, boolean descending, Data lastEntryKeyData) {
        boolean useCursor;
        boolean bl = useCursor = lastEntryKeyData != null;
        if (useCursor && !descending && !fromInclusive) {
            throw new IllegalArgumentException("If `lastEntryKeyData` is not null then `from` must be inclusive");
        }
        if (useCursor && descending && !toInclusive) {
            throw new IllegalArgumentException("If `lastEntryKeyData` is not null then `to` must be inclusive");
        }
        int order = SPECIAL_AWARE_COMPARATOR.compare(from, to);
        if (order == 0) {
            if (!fromInclusive || !toInclusive) {
                return Collections.emptyIterator();
            }
            return this.getSqlRecordIteratorBatch(from, descending, lastEntryKeyData);
        }
        if (order > 0) {
            return Collections.emptyIterator();
        }
        NavigableMap subMap = descending ? this.recordMap.subMap((Object)from, fromInclusive, (Object)to, toInclusive).descendingMap() : this.recordMap.subMap((Object)from, fromInclusive, (Object)to, toInclusive);
        Comparable indexKeyForLastEntryKeyData = descending ? to : from;
        return subMap.entrySet().stream().map(es -> {
            NavigableMap map;
            NavigableMap navigableMap = map = descending ? ((NavigableMap)es.getValue()).descendingMap() : (NavigableMap)es.getValue();
            if (useCursor && SPECIAL_AWARE_COMPARATOR.compare(indexKeyForLastEntryKeyData, (Comparable)es.getKey()) == 0) {
                map = map.tailMap(lastEntryKeyData, false);
            }
            return new IndexKeyEntries((Comparable)es.getKey(), map.values().iterator());
        }).iterator();
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        this.takeReadLock();
        try {
            Set<QueryableEntry> set = this.toSingleResultSet((Map<Data, QueryableEntry>)this.recordMap.get(value));
            return set;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Set<Comparable> values) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            for (Comparable value : values) {
                Map records = this.recordMap.get(value);
                if (records == null) continue;
                this.copyToMultiResultSet(results, records);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparison comparison, Comparable searchedValue) {
        switch (comparison) {
            case LESS: {
                return this.getRecords(AbstractIndex.NULL, false, searchedValue, false);
            }
            case LESS_OR_EQUAL: {
                return this.getRecords(AbstractIndex.NULL, false, searchedValue, true);
            }
            case GREATER: {
                return this.getRecords(searchedValue, false, CompositeValue.POSITIVE_INFINITY, true);
            }
            case GREATER_OR_EQUAL: {
                return this.getRecords(searchedValue, true, CompositeValue.POSITIVE_INFINITY, true);
            }
        }
        throw new IllegalArgumentException("Unrecognized comparison: " + String.valueOf((Object)comparison));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive) {
        this.takeReadLock();
        try {
            int order = SPECIAL_AWARE_COMPARATOR.compare(from, to);
            if (order == 0) {
                if (!fromInclusive || !toInclusive) {
                    Set<QueryableEntry> set = Collections.emptySet();
                    return set;
                }
                Set<QueryableEntry> set = this.toSingleResultSet((Map<Data, QueryableEntry>)this.recordMap.get(from));
                return set;
            }
            if (order > 0) {
                Set<QueryableEntry> set = Collections.emptySet();
                return set;
            }
            MultiResultSet results = this.createMultiResultSet();
            NavigableMap subMap = this.recordMap.subMap((Object)from, fromInclusive, (Object)to, toInclusive);
            for (Map value : subMap.values()) {
                this.copyToMultiResultSet(results, value);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private class CopyOnWriteAddFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> {
        private CopyOnWriteAddFunctor() {
        }

        @Override
        public Object invoke(Comparable value, QueryableEntry entry) {
            NavigableMap<Data, QueryableEntry> records = OrderedIndexStore.this.recordMap.get(value);
            if (records == null) {
                records = new TreeMap<Data, QueryableEntry>(DATA_COMPARATOR);
            }
            records = new TreeMap<Data, QueryableEntry>((SortedMap<Data, QueryableEntry>)records);
            QueryableEntry oldValue = records.put(entry.getKeyData(), entry);
            OrderedIndexStore.this.recordMap.put(value, records);
            return oldValue;
        }
    }

    private class CopyOnWriteRemoveFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, Data> {
        private CopyOnWriteRemoveFunctor() {
        }

        @Override
        public Object invoke(Comparable value, Data indexKey) {
            Object oldValue;
            NavigableMap<Data, QueryableEntry> records = OrderedIndexStore.this.recordMap.get(value);
            if (records != null) {
                records = new TreeMap<Data, QueryableEntry>((SortedMap<Data, QueryableEntry>)records);
                oldValue = records.remove(indexKey);
                if (records.isEmpty()) {
                    OrderedIndexStore.this.recordMap.remove(value);
                } else {
                    OrderedIndexStore.this.recordMap.put(value, records);
                }
            } else {
                oldValue = null;
            }
            return oldValue;
        }
    }

    private class AddFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> {
        private AddFunctor() {
        }

        @Override
        public Object invoke(Comparable value, QueryableEntry entry) {
            return OrderedIndexStore.this.recordMap.computeIfAbsent(value, x -> new ConcurrentSkipListMap(DATA_COMPARATOR)).put(entry.getKeyData(), entry);
        }
    }

    private class RemoveFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, Data> {
        private RemoveFunctor() {
        }

        @Override
        public Object invoke(Comparable value, Data indexKey) {
            Object oldValue;
            Map records = OrderedIndexStore.this.recordMap.get(value);
            if (records != null) {
                oldValue = records.remove(indexKey);
                if (records.isEmpty()) {
                    OrderedIndexStore.this.recordMap.remove(value);
                }
            } else {
                oldValue = null;
            }
            return oldValue;
        }
    }

    private static final class IteratorFromBatch
    implements Iterator<QueryableEntry> {
        private final Iterator<IndexKeyEntries> iterator;
        private Iterator<QueryableEntry> indexKeyIterator;

        private IteratorFromBatch(@Nonnull Iterator<IndexKeyEntries> iterator) {
            this.iterator = iterator;
            this.indexKeyIterator = iterator.hasNext() ? iterator.next().getEntries() : null;
        }

        @Override
        public boolean hasNext() {
            if (this.indexKeyIterator == null) {
                return false;
            }
            if (this.indexKeyIterator.hasNext()) {
                return true;
            }
            while (this.iterator.hasNext()) {
                this.indexKeyIterator = this.iterator.next().getEntries();
                if (!this.indexKeyIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public QueryableEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.indexKeyIterator.next();
        }
    }

    private static class DataComparator
    implements Comparator<Data> {
        private DataComparator() {
        }

        @Override
        public int compare(Data o1, Data o2) {
            byte[] thisBytes = o1.toByteArray();
            byte[] thatBytes = o2.toByteArray();
            return Arrays.compare(thisBytes, thatBytes);
        }
    }
}

