/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class MapIndexInfo
implements IdentifiedDataSerializable {
    private String mapName;
    private List<IndexConfig> indexConfigs = new LinkedList<IndexConfig>();

    public MapIndexInfo(String mapName) {
        this.mapName = mapName;
    }

    public MapIndexInfo() {
    }

    public MapIndexInfo addIndexCofigs(Collection<IndexConfig> indexConfigs) {
        this.indexConfigs.addAll(indexConfigs);
        return this;
    }

    public String getMapName() {
        return this.mapName;
    }

    public List<IndexConfig> getIndexConfigs() {
        return this.indexConfigs;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.mapName);
        out.writeInt(this.indexConfigs.size());
        for (IndexConfig indexConfig : this.indexConfigs) {
            out.writeObject(indexConfig);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readString();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            IndexConfig indexConfig = (IndexConfig)in.readObject();
            this.indexConfigs.add(indexConfig);
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 94;
    }
}

