/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.monitor.impl.PerIndexStats;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.BitmapIndexStore;
import com.hazelcast.query.impl.GlobalIndexPartitionTracker;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.OrderedIndexStore;
import com.hazelcast.query.impl.UnorderedIndexStore;
import com.hazelcast.query.impl.getters.Extractors;

public class IndexImpl
extends AbstractIndex {
    private final GlobalIndexPartitionTracker partitionTracker;

    public IndexImpl(Node node, IndexConfig config, InternalSerializationService ss, Extractors extractors, IndexCopyBehavior copyBehavior, PerIndexStats stats, int partitionCount, String mapName) {
        super(node, config, ss, extractors, copyBehavior, stats, mapName, -1);
        this.partitionTracker = new GlobalIndexPartitionTracker(partitionCount);
    }

    @Override
    protected IndexStore createIndexStore(Node node, IndexConfig config, PerIndexStats stats, String mapName, int ignored) {
        switch (config.getType()) {
            case SORTED: {
                return new OrderedIndexStore(this.copyBehavior);
            }
            case HASH: {
                return new UnorderedIndexStore(this.copyBehavior);
            }
            case BITMAP: {
                return new BitmapIndexStore(config);
            }
        }
        throw new IllegalArgumentException("unexpected index type: " + String.valueOf((Object)config.getType()));
    }

    @Override
    public final boolean hasPartitionIndexed(int partitionId) {
        return this.partitionTracker.isIndexed(partitionId);
    }

    @Override
    public final boolean allPartitionsIndexed(int ownedPartitionCount) {
        return ownedPartitionCount < 0 || this.partitionTracker.indexedCount() == ownedPartitionCount;
    }

    @Override
    public final void beginPartitionUpdate() {
        this.partitionTracker.beginPartitionUpdate();
    }

    @Override
    public final void markPartitionAsIndexed(int partitionId) {
        this.partitionTracker.partitionIndexed(partitionId);
    }

    @Override
    public final void markPartitionAsUnindexed(int partitionId) {
        this.partitionTracker.partitionUnindexed(partitionId);
    }

    @Override
    public final void clear() {
        this.partitionTracker.clear();
        super.clear();
    }

    @Override
    public final GlobalIndexPartitionTracker.PartitionStamp getPartitionStamp() {
        return this.partitionTracker.getPartitionStamp();
    }

    @Override
    public final boolean validatePartitionStamp(long stamp) {
        return this.partitionTracker.validatePartitionStamp(stamp);
    }

    @Override
    public String toString() {
        return "IndexImpl{partitionTracker=" + String.valueOf(this.partitionTracker) + "} " + super.toString();
    }
}

