/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.bplustree.HashIndexBPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.HashIndexEntrySlotPayload;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.Comparables;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.HDBaseConcurrentIndexStore;
import com.hazelcast.query.impl.HDUnorderedIndexStore;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexKeyEntries;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;

public class HDUnorderedConcurrentIndexStore
extends HDBaseConcurrentIndexStore {
    private final EnterpriseSerializationService ess;

    HDUnorderedConcurrentIndexStore(IndexCopyBehavior copyBehavior, EnterpriseSerializationService ess, MemoryAllocator keyAllocator, Function<String, MemoryAllocator> indexAllocatorConstructor, MapEntryFactory<QueryableEntry> entryFactory, int nodeSize, String indexName, boolean tstore) {
        super(copyBehavior, ess, keyAllocator, indexAllocatorConstructor, new HashIndexBPlusTreeKeyComparator(ess), entryFactory, nodeSize, new HashIndexEntrySlotPayload(), indexName, tstore);
        this.ess = ess;
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive) {
        Iterator<QueryableEntry> it = this.getSqlRecordIterator(HDUnorderedIndexStore.canonicalize(from), fromInclusive, HDUnorderedIndexStore.canonicalize(to), toInclusive, false);
        return this.buildResultSet(it);
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparison comparison, Comparable value) {
        Iterator<QueryableEntry> it = this.getSqlRecordIterator(comparison, HDUnorderedIndexStore.canonicalize(value), false);
        return this.buildResultSet(it);
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        return super.getRecords(HDUnorderedIndexStore.canonicalize(value));
    }

    @Override
    public Comparable canonicalizeScalarForStorage(Comparable value) {
        return HDUnorderedIndexStore.canonicalizeScalarForStorage0(value);
    }

    @Override
    public Comparable canonicalizeQueryArgumentScalar(Comparable value) {
        return this.canonicalizeScalarForStorage(value);
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable value) {
        return super.getSqlRecordIterator(HDUnorderedIndexStore.canonicalize(value));
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparison comparison, Comparable value, boolean descending) {
        return new ValueComparisonIterator(comparison, HDUnorderedIndexStore.canonicalize(value));
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        if (Comparables.compare(from, to) == 0) {
            if (!fromInclusive || !toInclusive) {
                return Collections.emptyIterator();
            }
            return this.getSqlRecordIterator(HDUnorderedIndexStore.canonicalize(from));
        }
        return new KeyRangeIterator(HDUnorderedIndexStore.canonicalize(from), fromInclusive, HDUnorderedIndexStore.canonicalize(to), toInclusive);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable value, boolean descending) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(boolean descending) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparison comparison, Comparable value, boolean descending) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private class ValueComparisonIterator
    implements Iterator<QueryableEntry> {
        private final Comparison comparison;
        private final Comparable value;
        private final Iterator<Data> keys;
        private Iterator<QueryableEntry> currentIterator;

        ValueComparisonIterator(Comparison comparison, Comparable value) {
            this.comparison = comparison;
            this.value = value;
            this.keys = HDUnorderedConcurrentIndexStore.this.records.getKeys();
        }

        @Override
        public boolean hasNext() {
            block6: while (true) {
                if (this.currentIterator == null) {
                    while (this.keys.hasNext()) {
                        Comparable indexedValue = (Comparable)HDUnorderedConcurrentIndexStore.this.ess.toObject(this.keys.next());
                        if (indexedValue == AbstractIndex.NULL) continue;
                        int result = Comparables.compare(this.value, indexedValue);
                        if (!(switch (this.comparison) {
                            case Comparison.LESS -> result > 0;
                            case Comparison.LESS_OR_EQUAL -> result >= 0;
                            case Comparison.GREATER -> result < 0;
                            case Comparison.GREATER_OR_EQUAL -> result <= 0;
                            default -> throw new IllegalStateException("Unrecognized comparison: " + String.valueOf((Object)this.comparison));
                        })) continue;
                        this.currentIterator = HDUnorderedConcurrentIndexStore.this.getSqlRecordIterator(indexedValue);
                        continue block6;
                    }
                    return false;
                }
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.currentIterator = null;
            }
        }

        @Override
        public QueryableEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }
    }

    private class KeyRangeIterator
    implements Iterator<QueryableEntry> {
        private final Comparable from;
        private final Comparable to;
        private final int fromBound;
        private final int toBound;
        private final Iterator<Data> keys;
        private Iterator<QueryableEntry> currentIterator;

        KeyRangeIterator(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive) {
            this.from = from;
            this.to = to;
            this.fromBound = fromInclusive ? 0 : 1;
            this.toBound = toInclusive ? 0 : -1;
            this.keys = HDUnorderedConcurrentIndexStore.this.records.getKeys();
        }

        @Override
        public boolean hasNext() {
            block0: while (true) {
                if (this.currentIterator == null) {
                    while (this.keys.hasNext()) {
                        Comparable value = (Comparable)HDUnorderedConcurrentIndexStore.this.ess.toObject(this.keys.next());
                        if (Comparables.compare(value, this.from) < this.fromBound || Comparables.compare(value, this.to) > this.toBound) continue;
                        this.currentIterator = HDUnorderedConcurrentIndexStore.this.getSqlRecordIterator(HDUnorderedIndexStore.canonicalize(value));
                        continue block0;
                    }
                    return false;
                }
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.currentIterator = null;
            }
        }

        @Override
        public QueryableEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }
    }
}

