/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.elastic.map.BehmSlotAccessorFactory;
import com.hazelcast.internal.elastic.map.BinaryElasticHashMap;
import com.hazelcast.internal.elastic.map.NativeBehmSlotAccessorFactory;
import com.hazelcast.internal.elastic.map.NativeMemoryDataAccessor;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.elastic.util.DisposalUtil;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.memory.MemoryBlockAccessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.query.impl.HDIndexBehmMemoryBlockAccessor;
import com.hazelcast.query.impl.HDIndexBehmSlotAccessorFactory;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class HDIndexNestedHashMap<T extends QueryableEntry> {
    private static final long NULL_ADDRESS = 0L;
    private static final ThreadLocal<Deque> THREAD_LOCAL_DISPOSE_QUEUE = ThreadLocal.withInitial(() -> new ArrayDeque(3));
    private final MemoryAllocator malloc;
    private final MapEntryFactory<T> mapEntryFactory;
    private final EnterpriseSerializationService ess;
    private final MemoryBlockAccessor behmMemoryBlockAccessor;
    private final BinaryElasticHashMap<NativeMemoryData> records;
    private final BehmSlotAccessorFactory behmSlotAccessorFactory;

    HDIndexNestedHashMap(EnterpriseSerializationService ess, MemoryAllocator malloc, MapEntryFactory<T> mapEntryFactory) {
        this.records = new BinaryElasticHashMap<NativeMemoryData>(ess, new NativeBehmSlotAccessorFactory(), new NativeMemoryDataAccessor(ess), malloc);
        this.ess = ess;
        this.malloc = malloc;
        this.mapEntryFactory = mapEntryFactory;
        this.behmSlotAccessorFactory = new HDIndexBehmSlotAccessorFactory();
        NativeMemoryDataAccessor valueAccessor = new NativeMemoryDataAccessor(ess);
        this.behmMemoryBlockAccessor = new HDIndexBehmMemoryBlockAccessor(valueAccessor);
    }

    public MemoryBlock put(Comparable segment, NativeMemoryData keyData, MemoryBlock value) {
        Object segmentData = this.ess.toData((Object)segment, DataType.HEAP);
        this.checkNotNullOrEmpty((Data)segmentData, "segment can't be null or empty");
        this.checkNotNullOrEmpty(keyData, "key can't be null or empty");
        NativeMemoryData mapHeader = (NativeMemoryData)this.records.get(segmentData);
        Deque disposeQueue = THREAD_LOCAL_DISPOSE_QUEUE.get();
        disposeQueue.clear();
        try {
            BinaryElasticHashMap<MemoryBlock> map;
            if (this.isNullOrEmptyData(mapHeader)) {
                map = new BinaryElasticHashMap<MemoryBlock>(this.ess, this.behmSlotAccessorFactory, this.behmMemoryBlockAccessor, this.malloc);
                disposeQueue.offer(map);
                mapHeader = map.storeHeaderOffHeap(this.malloc, 0L);
                disposeQueue.offer(mapHeader);
                Object nativeSegmentData = this.ess.toNativeData(segmentData, this.malloc);
                disposeQueue.offer(nativeSegmentData);
                NativeMemoryData oldValue = this.records.put((Data)nativeSegmentData, mapHeader);
                if (oldValue != null) {
                    throw new ConcurrentModificationException();
                }
            } else {
                map = BinaryElasticHashMap.loadFromOffHeapHeader(this.ess, this.malloc, mapHeader.address(), this.behmSlotAccessorFactory, this.behmMemoryBlockAccessor);
            }
            MemoryBlock oldValueData = map.put(keyData, value == null ? new NativeMemoryData() : value);
            map.storeHeaderOffHeap(this.malloc, mapHeader.address());
            return oldValueData;
        }
        catch (NativeOutOfMemoryError e) {
            while (!disposeQueue.isEmpty()) {
                this.dispose(disposeQueue.pollLast());
            }
            throw e;
        }
    }

    public Set<NativeMemoryData> keySet() {
        Set<Data> keySet = this.records.keySet();
        return keySet;
    }

    public Set<T> get(Comparable segment) {
        Object segmentData = this.ess.toData((Object)segment, DataType.HEAP);
        this.checkNotNullOrEmpty((Data)segmentData, "segment can't be null or empty");
        NativeMemoryData mapHeader = (NativeMemoryData)this.records.get(segmentData);
        if (this.isNullOrEmptyData(mapHeader)) {
            return Collections.emptySet();
        }
        HashSet<QueryableEntry> result = new HashSet<QueryableEntry>();
        BinaryElasticHashMap map = BinaryElasticHashMap.loadFromOffHeapHeader(this.ess, this.malloc, mapHeader.address(), this.behmSlotAccessorFactory, this.behmMemoryBlockAccessor);
        for (Map.Entry entry : map.entrySet()) {
            result.add((QueryableEntry)this.mapEntryFactory.create(entry.getKey(), (NativeMemoryData)entry.getValue()));
        }
        return result;
    }

    public MemoryBlock remove(Comparable segment, NativeMemoryData key) {
        Object segmentData = this.ess.toData((Object)segment, DataType.HEAP);
        this.checkNotNullOrEmpty((Data)segmentData, "segment can't be null or empty");
        this.checkNotNullOrEmpty(key, "key can't be null or empty");
        NativeMemoryData mapHeader = (NativeMemoryData)this.records.get(segmentData);
        if (this.isNullOrEmptyData(mapHeader)) {
            return null;
        }
        BinaryElasticHashMap map = BinaryElasticHashMap.loadFromOffHeapHeader(this.ess, this.malloc, mapHeader.address(), this.behmSlotAccessorFactory, this.behmMemoryBlockAccessor);
        Object value = map.remove(key);
        if (map.isEmpty()) {
            map.dispose();
            NativeMemoryData mapHeaderOnRemove = (NativeMemoryData)this.records.remove(segmentData);
            this.ess.disposeData(mapHeaderOnRemove, this.malloc);
        } else {
            map.storeHeaderOffHeap(this.malloc, mapHeader.address());
        }
        return value;
    }

    public void clear() {
        for (NativeMemoryData mapHeader : this.records.values()) {
            if (this.isNullOrEmptyData(mapHeader)) continue;
            BinaryElasticHashMap map = BinaryElasticHashMap.loadFromOffHeapHeader(this.ess, this.malloc, mapHeader.address(), this.behmSlotAccessorFactory, this.behmMemoryBlockAccessor);
            map.dispose();
        }
        this.records.clear();
    }

    public void dispose() {
        this.records.dispose();
    }

    public long size() {
        long size = 0L;
        Iterator<NativeMemoryData> iterator = this.records.valueIter();
        while (iterator.hasNext()) {
            BinaryElasticHashMap map = BinaryElasticHashMap.loadFromOffHeapHeader(this.ess, this.malloc, iterator.next().address(), this.behmSlotAccessorFactory, this.behmMemoryBlockAccessor);
            size += (long)map.size();
        }
        return size;
    }

    private boolean isNullOrEmptyData(Data data) {
        return data == null || data.totalSize() == 0;
    }

    private void checkNotNullOrEmpty(Data data, String message) {
        if (this.isNullOrEmptyData(data)) {
            throw new IllegalArgumentException(message);
        }
    }

    private void dispose(Object object) {
        DisposalUtil.dispose(this.ess, this.malloc, object);
    }
}

