/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.elastic.map.BinaryElasticHashMap;
import com.hazelcast.internal.elastic.map.NativeMemoryDataAccessor;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.query.impl.HDIndexBehmMemoryBlockAccessor;
import com.hazelcast.query.impl.HDIndexBehmSlotAccessorFactory;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class HDIndexHashMap<T extends QueryableEntry> {
    private final MapEntryFactory<T> entryFactory;
    private final EnterpriseSerializationService ess;
    private final MemoryAllocator malloc;
    private BinaryElasticHashMap<MemoryBlock> records;

    HDIndexHashMap(EnterpriseSerializationService ess, MemoryAllocator malloc, MapEntryFactory<T> entryFactory) {
        this.ess = ess;
        this.malloc = malloc;
        NativeMemoryDataAccessor valueAccessor = new NativeMemoryDataAccessor(ess);
        this.records = new BinaryElasticHashMap<MemoryBlock>(ess, new HDIndexBehmSlotAccessorFactory(), new HDIndexBehmMemoryBlockAccessor(valueAccessor), malloc);
        this.entryFactory = entryFactory;
    }

    public MemoryBlock put(NativeMemoryData keyData, MemoryBlock valueData) {
        Objects.requireNonNull(keyData, "record can't be null");
        if (valueData == null) {
            valueData = new NativeMemoryData();
        }
        return this.records.put(keyData, valueData);
    }

    public MemoryBlock remove(Data key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.records.remove(key);
    }

    public Set<T> entrySet() {
        HashSet<QueryableEntry> result = new HashSet<QueryableEntry>();
        for (Map.Entry<Data, MemoryBlock> entry : this.records.entrySet()) {
            Data key = entry.getKey();
            MemoryBlock memoryBlock = entry.getValue();
            result.add((QueryableEntry)this.entryFactory.create(entry.getKey(), (NativeMemoryData)memoryBlock));
        }
        return result;
    }

    public void clear() {
        this.records.dispose();
        NativeMemoryDataAccessor valueAccessor = new NativeMemoryDataAccessor(this.ess);
        this.records = new BinaryElasticHashMap<MemoryBlock>(this.ess, new HDIndexBehmSlotAccessorFactory(), new HDIndexBehmMemoryBlockAccessor(valueAccessor), this.malloc);
    }

    public void dispose() {
        this.records.dispose();
    }

    public long size() {
        return this.records.size();
    }
}

