/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.DefaultBPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.map.impl.recordstore.CompactionAwareStorage;
import com.hazelcast.map.impl.recordstore.CustomStepAwareStorage;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.BaseSingleValueIndexStore;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.HDBPlusTreeIndex;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.TSBPlusTreeIndex;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;

abstract class HDBaseConcurrentIndexStore
extends BaseSingleValueIndexStore {
    protected final HDBPlusTreeIndex<QueryableEntry> records;
    protected final BPlusTreeKeyComparator indexKeyComparator;
    private final EnterpriseSerializationService ess;
    private final boolean isTStore;
    private final MemoryAllocator keyAllocator;

    HDBaseConcurrentIndexStore(IndexCopyBehavior copyBehavior, EnterpriseSerializationService ess, MemoryAllocator keyAllocator, Function<String, MemoryAllocator> indexAllocatorConstructor, BPlusTreeKeyComparator keyComparator, MapEntryFactory<QueryableEntry> entryFactory, int nodeSize, EntrySlotPayload entrySlotPayload, String indexName, boolean tstore) {
        super(copyBehavior, false);
        this.isTStore = tstore;
        this.keyAllocator = keyAllocator;
        this.ess = ess;
        this.indexKeyComparator = keyComparator;
        this.records = tstore ? new TSBPlusTreeIndex<QueryableEntry>(ess, keyAllocator, indexAllocatorConstructor.apply("all"), entryFactory, keyComparator, (BPlusTreeKeyAccessor)new DefaultBPlusTreeKeyAccessor(ess), nodeSize, entrySlotPayload, indexName) : new HDBPlusTreeIndex<QueryableEntry>(ess, keyAllocator, indexAllocatorConstructor.apply("all"), entryFactory, keyComparator, new DefaultBPlusTreeKeyAccessor(ess), nodeSize, entrySlotPayload, tstore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object insertInternal(Comparable attributeValue, QueryableEntry entry) {
        if (this.isTStore) {
            Data keyData = entry.getKeyData();
            if (keyData instanceof NativeMemoryData) {
                return this.records.put(attributeValue, (NativeMemoryData)keyData, null);
            }
            NativeMemoryData nativeKeyData = (NativeMemoryData)this.ess.convertToNativeData(keyData, this.keyAllocator);
            try {
                MemoryBlock memoryBlock = this.records.put(attributeValue, nativeKeyData, null);
                return memoryBlock;
            }
            finally {
                this.ess.disposeData(nativeKeyData, this.keyAllocator);
            }
        }
        NativeMemoryData key = (NativeMemoryData)entry.getKeyData();
        MemoryBlock value = this.getValueToStore(entry);
        return this.records.put(attributeValue, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object removeInternal(Comparable attributeValue, Data key) {
        if (this.isTStore) {
            if (key instanceof NativeMemoryData) {
                return this.records.remove(attributeValue, (NativeMemoryData)key);
            }
            NativeMemoryData nativeKeyData = (NativeMemoryData)this.ess.convertToNativeData(key, this.keyAllocator);
            try {
                Data data = this.records.remove(attributeValue, nativeKeyData);
                return data;
            }
            finally {
                this.ess.disposeData(nativeKeyData, this.keyAllocator);
            }
        }
        return this.records.remove(attributeValue, (NativeMemoryData)key);
    }

    @Override
    public void clear() {
        this.records.clear();
    }

    @Override
    public void destroy() {
        this.dispose();
    }

    @Override
    public boolean isEvaluateOnly() {
        return false;
    }

    @Override
    public boolean canEvaluate(Class<? extends Predicate> predicateClass) {
        return false;
    }

    @Override
    public Set<QueryableEntry> evaluate(Predicate predicate, TypeConverter converter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        return this.doGetRecords(value);
    }

    @Override
    public Set<QueryableEntry> getRecords(Set<Comparable> values) {
        HashSet<QueryableEntry> results = new HashSet<QueryableEntry>();
        for (Comparable value : values) {
            results.addAll(this.getRecords(value));
        }
        return results;
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparison comparison, Comparable value) {
        return this.buildResultSet(this.getRecords0(comparison, value, false));
    }

    private void dispose() {
        this.records.dispose();
    }

    private MemoryBlock getValueToStore(QueryableEntry entry) {
        return (MemoryBlock)((Object)entry.getValueData());
    }

    private Set<QueryableEntry> doGetRecords(Comparable value) {
        return this.buildResultSet(this.records.lookup(value));
    }

    protected Set<QueryableEntry> buildResultSet(Iterator<QueryableEntry> it) {
        if (!it.hasNext()) {
            return Collections.emptySet();
        }
        HashSet<QueryableEntry> resultSet = new HashSet<QueryableEntry>();
        while (it.hasNext()) {
            resultSet.add(it.next());
        }
        return resultSet;
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(boolean descending) {
        return this.getRecords0(null, true, null, true, descending);
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable value) {
        return this.records.lookup(value);
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparison comparison, Comparable value, boolean descending) {
        return this.getRecords0(comparison, value, descending);
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        return this.getRecords0(from, fromInclusive, to, toInclusive, descending);
    }

    Iterator<QueryableEntry> getRecords0(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        return this.records.getKeysInRange(from, fromInclusive, to, toInclusive, descending);
    }

    private Iterator<QueryableEntry> getRecords0(Comparison comparison, Comparable value, boolean descending) {
        return switch (comparison) {
            case Comparison.LESS -> this.records.getKeysInRange(AbstractIndex.NULL, false, value, false, descending);
            case Comparison.LESS_OR_EQUAL -> this.records.getKeysInRange(AbstractIndex.NULL, false, value, true, descending);
            case Comparison.GREATER -> this.records.getKeysInRange(value, false, null, true, descending);
            case Comparison.GREATER_OR_EQUAL -> this.records.getKeysInRange(value, true, null, true, descending);
            default -> throw new IllegalArgumentException("Unrecognized comparison: " + String.valueOf((Object)comparison));
        };
    }

    int getNodeSize() {
        return this.records.getNodeSize();
    }

    public CustomStepAwareStorage getCustomStepAwareStorage() {
        assert (this.isTStore);
        return (TSBPlusTreeIndex)this.records;
    }

    public CompactionAwareStorage getCompactorAwareStorage() {
        return (TSBPlusTreeIndex)this.records;
    }

    public HybridLog getHybridLog() {
        assert (this.isTStore);
        TSBPlusTreeIndex btreeIndex = (TSBPlusTreeIndex)this.records;
        return btreeIndex.getHybridLog();
    }
}

