/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.bplustree.HDBPlusTree;
import com.hazelcast.internal.bplustree.TStoreAllocator;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.query.impl.IndexKeyEntries;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Iterator;

public class HDBPlusTreeIndex<T extends QueryableEntry> {
    protected final HDBPlusTree recordMap;

    HDBPlusTreeIndex(EnterpriseSerializationService ess, MemoryAllocator keyAllocator, MemoryAllocator btreeAllocator, MapEntryFactory<T> entryFactory, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, int nodeSize, EntrySlotPayload entrySlotPayload, boolean tstore) {
        this.recordMap = tstore ? HDBPlusTree.newTStoreBTree(ess, keyAllocator, (TStoreAllocator)btreeAllocator, keyComparator, keyAccessor, entryFactory, nodeSize, entrySlotPayload) : HDBPlusTree.newHDBTree(ess, keyAllocator, btreeAllocator, keyComparator, keyAccessor, entryFactory, nodeSize, entrySlotPayload);
    }

    public MemoryBlock put(Comparable attribute, NativeMemoryData key, MemoryBlock value) {
        return this.recordMap.insert(attribute, key, value);
    }

    public Data remove(Comparable attribute, NativeMemoryData key) {
        return this.recordMap.remove(attribute, key);
    }

    public Iterator<QueryableEntry> getKeysInRange(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        Comparable from0 = from;
        boolean fromInclusive0 = fromInclusive;
        Comparable to0 = to;
        boolean toInclusive0 = toInclusive;
        if (descending) {
            from0 = to;
            fromInclusive0 = toInclusive;
            to0 = from;
            toInclusive0 = fromInclusive;
        }
        return this.recordMap.lookup(from0, fromInclusive0, to0, toInclusive0, descending);
    }

    public Iterator<IndexKeyEntries> getKeysInRangeBatch(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        return this.getKeysInRangeBatch(from, fromInclusive, to, toInclusive, descending, null);
    }

    public Iterator<IndexKeyEntries> getKeysInRangeBatch(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending, Data keyFrom) {
        Comparable from0 = from;
        boolean fromInclusive0 = fromInclusive;
        Comparable to0 = to;
        boolean toInclusive0 = toInclusive;
        if (descending) {
            from0 = to;
            fromInclusive0 = toInclusive;
            to0 = from;
            toInclusive0 = fromInclusive;
        }
        return this.recordMap.lookupBatch(from0, fromInclusive0, to0, toInclusive0, descending, keyFrom);
    }

    public Iterator<QueryableEntry> lookup(Comparable value) {
        return this.recordMap.lookup(value, true, value, true, false);
    }

    public Iterator<Data> getKeys() {
        return this.recordMap.keys();
    }

    public void clear() {
        this.recordMap.clear();
    }

    public void dispose() {
        this.recordMap.dispose();
    }

    int getNodeSize() {
        return this.recordMap.getNodeSize();
    }
}

