/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.util.collection.PartitionIdSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GlobalIndexPartitionTracker {
    private static final long STAMP_INITIAL = 0L;
    private final ReentrantLock lock = new ReentrantLock();
    private final int partitionCount;
    private final AtomicReference<State> state;

    public GlobalIndexPartitionTracker(int partitionCount) {
        this.partitionCount = partitionCount;
        this.state = new AtomicReference<State>(new State(0L, new PartitionIdSet(partitionCount), 0));
    }

    @Nullable
    public PartitionStamp getPartitionStamp() {
        State state0 = this.state.get();
        if (state0.pending > 0) {
            return null;
        }
        return new PartitionStamp(state0.stamp, state0.indexedPartitions);
    }

    public boolean validatePartitionStamp(long stamp) {
        return this.state.get().stamp == stamp;
    }

    public boolean isIndexed(int partitionId) {
        return this.state.get().indexedPartitions.contains(partitionId);
    }

    public int indexedCount() {
        return this.state.get().indexedPartitions.size();
    }

    public void beginPartitionUpdate() {
        this.lock.lock();
        try {
            State oldState = this.state.get();
            State newState = new State(oldState.stamp + 1L, oldState.indexedPartitions, oldState.pending + 1);
            this.state.set(newState);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void partitionIndexed(int partition) {
        this.complete(partition, true);
    }

    public void partitionUnindexed(int partition) {
        this.complete(partition, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(int partition, boolean indexed) {
        this.lock.lock();
        try {
            State oldState = this.state.get();
            assert (oldState.pending > 0);
            PartitionIdSet newIndexedPartitions = oldState.indexedPartitions.copy();
            if (indexed) {
                newIndexedPartitions.add(partition);
            } else {
                newIndexedPartitions.remove(partition);
            }
            State newState = new State(oldState.stamp + 1L, newIndexedPartitions, oldState.pending - 1);
            this.state.set(newState);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            State oldState = this.state.get();
            State newState = new State(oldState.stamp + 1L, new PartitionIdSet(this.partitionCount), 0);
            this.state.set(newState);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "GlobalIndexPartitionTracker{partitionCount=" + this.partitionCount + ", state=" + String.valueOf(this.state) + "}";
    }

    private static final class State {
        private final long stamp;
        private final PartitionIdSet indexedPartitions;
        private final int pending;

        private State(long stamp, PartitionIdSet indexedPartitions, int pending) {
            this.stamp = stamp;
            this.indexedPartitions = indexedPartitions;
            this.pending = pending;
        }

        public String toString() {
            return "State{stamp=" + this.stamp + ", indexedPartitions={size=" + this.indexedPartitions.size() + ", partitions=" + String.valueOf(this.indexedPartitions) + "}, pending=" + this.pending + "}";
        }
    }

    public static final class PartitionStamp {
        public final long stamp;
        @Nonnull
        public final PartitionIdSet partitions;

        public PartitionStamp(long stamp, @Nonnull PartitionIdSet partitions) {
            this.stamp = stamp;
            this.partitions = partitions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionStamp that = (PartitionStamp)o;
            return this.stamp == that.stamp && this.partitions.equals(that.partitions);
        }

        public int hashCode() {
            return Objects.hash(this.stamp, this.partitions);
        }

        public String toString() {
            return "PartitionStamp{stamp=" + this.stamp + ", partitions=" + String.valueOf(this.partitions) + "}";
        }
    }
}

