/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ssl;

import com.hazelcast.internal.nio.ssl.SSLEngineFactorySupport;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ssl.SSLContextFactory;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class BasicSSLContextFactory
extends SSLEngineFactorySupport
implements SSLContextFactory {
    private final AtomicBoolean logTheWarning = new AtomicBoolean(true);

    @Override
    public void init(Properties properties) throws Exception {
        this.load(properties);
        SSLContext.getInstance(this.protocol);
    }

    @Override
    public SSLContext getSSLContext() {
        try {
            SSLEngineFactorySupport.KeyMaterial km = this.getKeyMaterial();
            TrustManagerFactory tmf = km.getTrustManagerFactory();
            KeyManagerFactory kmf = km.getKeyManagerFactory();
            if (tmf == null && this.logTheWarning.getAndSet(false)) {
                Logger.getLogger(this.getClass()).warning("The trustStore is not configured in Hazelcast TLS/SSL configuration! Java platform default will be used. This can reduce the security level provided.");
            }
            KeyManager[] keyManagers = kmf == null ? null : kmf.getKeyManagers();
            TrustManager[] trustManagers = tmf == null ? null : tmf.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance(this.protocol);
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

