/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.WanSupportingService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MerkleTreeNodeEntries;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.wan.WanEnterpriseMapAddOrUpdateEvent;
import com.hazelcast.map.impl.wan.WanEnterpriseMapEvent;
import com.hazelcast.map.impl.wan.WanEnterpriseMapMerkleTreeNode;
import com.hazelcast.map.impl.wan.WanEnterpriseMapRemoveEvent;
import com.hazelcast.map.impl.wan.WanEnterpriseMapSyncEvent;
import com.hazelcast.map.impl.wan.WanMapEntryView;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.merge.MapMergingEntryImpl;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.proxyservice.ProxyService;
import com.hazelcast.spi.merge.PassThroughMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Semaphore;

public class WanEnterpriseMapSupportingService
implements WanSupportingService {
    private static final String DEFAULT_MERGE_POLICY = PassThroughMergePolicy.class.getName();
    private static final HazelcastProperty WAN_SYNC_TARGET_MAX_CONCURRENT_INVOCATION_COUNT = new HazelcastProperty("hazelcast.internal.wan.sync.target.max.concurrent.invocation.count", 100);
    private final NodeEngine nodeEngine;
    private final ProxyService proxyService;
    private final MapServiceContext mapServiceContext;
    private final WanEventCounters wanEventCounters;
    private final SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> defaultSyncMergePolicy;
    private final Semaphore syncSemaphore;

    public WanEnterpriseMapSupportingService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        SplitBrainMergePolicyProvider mergePolicyProvider = this.nodeEngine.getSplitBrainMergePolicyProvider();
        this.defaultSyncMergePolicy = mergePolicyProvider.getMergePolicy(DEFAULT_MERGE_POLICY);
        this.proxyService = this.nodeEngine.getProxyService();
        this.wanEventCounters = this.nodeEngine.getWanReplicationService().getReceivedEventCounters("hz:impl:mapService");
        int permits = this.nodeEngine.getProperties().getInteger(WAN_SYNC_TARGET_MAX_CONCURRENT_INVOCATION_COUNT) - 1;
        this.syncSemaphore = new Semaphore(permits);
    }

    @Override
    public void onReplicationEvent(InternalWanEvent event, WanAcknowledgeType acknowledgeType) {
        if (!(event instanceof WanEnterpriseMapAddOrUpdateEvent) && !(event instanceof WanEnterpriseMapRemoveEvent)) {
            return;
        }
        String mapName = this.initProxies(event);
        this.republishIfNecessary(event, mapName);
        if (event instanceof WanEnterpriseMapAddOrUpdateEvent) {
            this.handleUpdateEvent((WanEnterpriseMapAddOrUpdateEvent)event, acknowledgeType);
            this.wanEventCounters.incrementUpdate(mapName);
        } else {
            this.handleRemoveEvent((WanEnterpriseMapRemoveEvent)event, acknowledgeType);
            this.wanEventCounters.incrementRemove(mapName);
        }
    }

    @Override
    public CompletionStage<Void> onSyncBatch(Collection<InternalWanEvent> batch, final WanAcknowledgeType acknowledgeType) {
        LinkedList futures = new LinkedList<CompletableFuture<?>>(){

            @Override
            public boolean add(CompletableFuture<?> o) {
                if (acknowledgeType == WanAcknowledgeType.ACK_ON_RECEIPT) {
                    return true;
                }
                o.whenCompleteAsync((v, t) -> WanEnterpriseMapSupportingService.this.syncSemaphore.release(), ConcurrencyUtil.CALLER_RUNS);
                try {
                    WanEnterpriseMapSupportingService.this.syncSemaphore.acquire();
                }
                catch (InterruptedException e) {
                    throw new HazelcastException(e);
                }
                return super.add(o);
            }
        };
        for (InternalWanEvent event : batch) {
            String mapName;
            if (event instanceof WanEnterpriseMapSyncEvent) {
                mapName = this.initProxies(event);
                futures.add(this.handleEntryToSync(mapName, ((WanEnterpriseMapSyncEvent)event).getEntryView()));
                continue;
            }
            if (!(event instanceof WanEnterpriseMapMerkleTreeNode)) continue;
            mapName = this.initProxies(event);
            MerkleTreeNodeEntries merkleTreeNodeEntries = ((WanEnterpriseMapMerkleTreeNode)event).getEntries();
            for (WanMapEntryView<Object, Object> entryView : merkleTreeNodeEntries.getNodeEntries()) {
                futures.add(this.handleEntryToSync(mapName, entryView));
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    @Override
    public void onWanConfigChange() {
        this.mapServiceContext.getMapContainers().values().forEach(container -> container.getWanContext().start());
    }

    private String initProxies(InternalWanEvent event) {
        WanEnterpriseMapEvent mapReplicationObject = (WanEnterpriseMapEvent)event;
        String mapName = mapReplicationObject.getMapName();
        UUID source = this.nodeEngine.getLocalMember().getUuid();
        this.proxyService.getDistributedObject("hz:impl:mapService", mapName, source);
        return mapName;
    }

    private void republishIfNecessary(InternalWanEvent event, String mapName) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        if (mapContainer.getWanContext().isWanRepublishingEnabled()) {
            mapContainer.getWanContext().getWanReplicationDelegate().republishReplicationEvent(event);
        }
    }

    private void handleUpdateEvent(WanEnterpriseMapAddOrUpdateEvent event, WanAcknowledgeType acknowledgeType) {
        MapOperation operation;
        String mapName = event.getMapName();
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(mapName);
        Object mergePolicy = event.getMergePolicy();
        MapMergingEntryImpl<Object, Object> mergingEntry = MergingValueFactory.createMergingEntry(this.nodeEngine.getSerializationService(), event.getEntryView());
        Data key = mergingEntry.getRawKey();
        InternalCompletableFuture future = this.invokeOnPartition(key, operation = operationProvider.createMergeOperation(mapName, mergingEntry, (SplitBrainMergePolicy)mergePolicy, true));
        if (future != null && acknowledgeType == WanAcknowledgeType.ACK_ON_OPERATION_COMPLETE) {
            future.joinInternal();
        }
    }

    private void handleRemoveEvent(WanEnterpriseMapRemoveEvent event, WanAcknowledgeType acknowledgeType) {
        String mapName = event.getMapName();
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(mapName);
        MapOperation operation = operationProvider.createDeleteOperation(mapName, event.getKey(), true);
        InternalCompletableFuture future = this.invokeOnPartition(event.getKey(), operation);
        if (future != null && acknowledgeType == WanAcknowledgeType.ACK_ON_OPERATION_COMPLETE) {
            future.joinInternal();
        }
    }

    private InternalCompletableFuture<?> handleEntryToSync(String mapName, WanMapEntryView<Object, Object> entryView) {
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(mapName);
        MapMergingEntryImpl<Object, Object> mergingEntry = MergingValueFactory.createMergingEntry(this.nodeEngine.getSerializationService(), entryView);
        MapOperation operation = operationProvider.createMergeOperation(mapName, mergingEntry, this.defaultSyncMergePolicy, true);
        return this.invokeOnPartition(mergingEntry.getRawKey(), operation);
    }

    private <E> InternalCompletableFuture<E> invokeOnPartition(Data key, Operation operation) {
        try {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(key);
            return this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }
}

