/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;
import java.util.UUID;

public class TxnPrepareBackupOperation
extends KeyBasedMapOperation
implements BackupOperation {
    private static final long LOCK_TTL_MILLIS = 10000L;
    private UUID lockOwnerUuid;
    private UUID transactionId;

    protected TxnPrepareBackupOperation(String name, Data dataKey, UUID lockOwnerUuid, long lockThreadId, UUID transactionId) {
        super(name, dataKey);
        this.lockOwnerUuid = lockOwnerUuid;
        this.threadId = lockThreadId;
        this.transactionId = transactionId;
    }

    public TxnPrepareBackupOperation() {
    }

    @Override
    protected void runInternal() {
        this.wbqCapacityCounter().increment(this.transactionId, true);
        if (!this.recordStore.txnLock(this.getKey(), this.lockOwnerUuid, this.threadId, this.getCallId(), 10000L, true)) {
            this.wbqCapacityCounter().decrement(this.transactionId);
            throw new TransactionException("Lock is not owned by the transaction! Caller: " + String.valueOf(this.lockOwnerUuid) + ", Owner: " + this.recordStore.getLockOwnerInfo(this.getKey()));
        }
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.lockOwnerUuid);
        UUIDSerializationUtil.writeUUID(out, this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.lockOwnerUuid = UUIDSerializationUtil.readUUID(in);
        this.transactionId = UUIDSerializationUtil.readUUID(in);
    }

    @Override
    public int getClassId() {
        return 66;
    }
}

