/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hidensity.impl.TieredStoreRecordProcessor;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.compaction.CompactorFlags;
import com.hazelcast.internal.tstore.compaction.LogBasedCompactor;
import com.hazelcast.internal.tstore.compaction.PartitionCompactor;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.hybridlog.AddressRemapper;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.HybridLogDirectAccessor;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import com.hazelcast.internal.tstore.hybridlog.PinType;
import com.hazelcast.internal.tstore.hybridlog.impl.AddressRemapperImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.map.impl.EnterpriseMapContainer;
import com.hazelcast.map.impl.EntryCostEstimator;
import com.hazelcast.map.impl.NotifiableIterator;
import com.hazelcast.map.impl.OwnedEntryCostEstimatorFactory;
import com.hazelcast.map.impl.TieredStoreMapEntryCostEstimator;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.iterator.MapKeysWithCursor;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.TieredStoreRecordFactory;
import com.hazelcast.map.impl.record.UnguardedTieredStoreRecordAccessor;
import com.hazelcast.map.impl.recordstore.CompactionAwareStorage;
import com.hazelcast.map.impl.recordstore.CompactorContext;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class TieredStorageImpl
implements Storage<Data, TieredStoreRecord>,
CompactionAwareStorage {
    private static final AddressRemapper<TieredStoreRecord> NOP_REMAPPER = (record, oldLogicalAddress, newLogicalAddress, threadIndex) -> newLogicalAddress;
    private final Index index;
    private final Epoch epoch;
    private final State state;
    private final Device device;
    private final HybridLogImpl hybridLog;
    private final HazelcastProperties properties;
    private final TieredStoreRecordFactory recordFactory;
    private final TieredStoreRecordAccessor recordAccessor;
    private final TieredStoreRecordProcessor recordProcessor;
    private final int partitionId;
    private final TStoreUserId userId;
    private final HiDensityStorageInfo storageInfo;
    private final EnterpriseSerializationService ess;
    private final AddressRemapper<TieredStoreRecord> addressUpdater;
    private final CompactorContext compactorContext;
    private volatile LogBasedCompactor partitionCompactor;
    private long localUsedMemory;
    private EntryCostEstimator<NativeMemoryData, TieredStoreRecord> entryCostEstimator;
    private final RecordInfo recordInfo = new RecordInfo();

    public TieredStorageImpl(TStoreUserId userId, int partitionId, TieredStoreRecordFactory recordFactory, Epoch epoch, HazelcastMemoryManager memoryManager, boolean statsEnabled, HiDensityStorageInfo hdStorageInfo, Supplier<CompactionManager> compactionManagerSupplier, HazelcastProperties properties) {
        this.recordFactory = recordFactory;
        this.recordProcessor = recordFactory.getRecordProcessor();
        this.properties = properties;
        this.recordAccessor = this.recordProcessor.getRecordAccessor();
        this.ess = this.recordProcessor.getSerializationService();
        this.epoch = epoch;
        this.userId = userId;
        this.partitionId = partitionId;
        this.state = new State(epoch.maxThreads());
        this.entryCostEstimator = statsEnabled ? new TieredStoreMapEntryCostEstimator() : OwnedEntryCostEstimatorFactory.ZERO_SIZE_ESTIMATOR;
        this.hybridLog = (HybridLogImpl)this.recordAccessor.getHybridLog();
        this.device = this.hybridLog.getDevice();
        this.index = this.createTStoreIndex(memoryManager);
        this.addressUpdater = new AddressRemapperImpl(this.hybridLog, this.index, false);
        this.storageInfo = hdStorageInfo;
        this.compactorContext = new CompactorContext(this.hybridLog, partitionId, this.index, this.state, userId, compactionManagerSupplier, this.recordAccessor, properties);
    }

    private Index createTStoreIndex(HazelcastMemoryManager memoryManager) {
        IndexDependencies dependencies = new IndexDependencies(this.recordProcessor, this.recordAccessor, (record, oldLogicalAddress, newLogicalAddressCandidate, threadIndex) -> this.getAddressRemapper().remap((TieredStoreRecord)record, oldLogicalAddress, newLogicalAddressCandidate, threadIndex), this.epoch, memoryManager.getSystemAllocator(), this.ess);
        return new Index(this.epoch, this.state, this.epoch.maxThreads(), dependencies);
    }

    public TStoreUserId getUserId() {
        return this.userId;
    }

    @Override
    public boolean supportsSteppedRun() {
        CompactorFlags compactorFlags = this.compactorContext.getCompactorFlags();
        if (!compactorFlags.isCompactorsEnabled()) {
            return true;
        }
        return compactorFlags.isPartitionCompactorEnabled();
    }

    @Override
    @Nullable
    public LogBasedCompactor<TieredStoreRecord> getPartitionCompactorOrNull() {
        return this.partitionCompactor;
    }

    @Override
    public void setPartitionCompactor(LogBasedCompactor partitionCompactor) {
        this.partitionCompactor = partitionCompactor;
    }

    @Override
    public LogBasedCompactor newPartitionCompactor(int segmentNo) {
        HybridLogImpl log = (HybridLogImpl)this.recordAccessor.getHybridLog();
        return new PartitionCompactor(this.recordAccessor, log, this.index, segmentNo, this.properties);
    }

    @Override
    public void collectCustomSteps(Consumer<Step> stepsCollector) {
        if (this.isPartitionMigrating()) {
            return;
        }
        CompactorFlags compactorFlags = this.compactorContext.getCompactorFlags();
        if (compactorFlags.isPartitionCompactorEnabled()) {
            this.addIndexSteps(stepsCollector);
            stepsCollector.accept(this.compactorContext.getPartitionCompactorStep());
            return;
        }
        if (!compactorFlags.isCompactorsEnabled()) {
            stepsCollector.accept(this.compactorContext.getPartitionCompactorStep());
            return;
        }
    }

    private void addIndexSteps(Consumer<Step> stepsCollector) {
        EnterpriseMapContainer mapContainer = this.recordFactory.getMapContainer();
        if (mapContainer.shouldUseGlobalIndex()) {
            return;
        }
        mapContainer.getCustomStepAwareStorage(this.partitionId, stepsCollector);
    }

    private boolean isPartitionMigrating() {
        return this.recordFactory.getMapContainer().getMapServiceContext().getNodeEngine().getPartitionService().getPartition(this.partitionId).isMigrating();
    }

    @Override
    public void put(Data key, TieredStoreRecord record) {
        assert (record.isPinned());
        int threadIndex = this.threadIndex();
        int oldMaxRecordChainLength = this.index.getMaxRecordChainLength();
        while (true) {
            if (!this.recordProcessor.isMutable(record.getLogicalAddress(), threadIndex)) {
                TieredStoreRecord readStatus = this.recordProcessor.getHybridLog().readRecordForUpdate(record.getLogicalAddress(), this.recordAccessor.getTieredStoreSlotAccessor(), NOP_REMAPPER);
                if (readStatus == Index.RETRY_RECORD) {
                    Thread.yield();
                    this.refreshEpochAndState(threadIndex);
                    continue;
                }
                record = readStatus;
            }
            assert (this.recordProcessor.isMutable(record.getLogicalAddress(), threadIndex));
            long status = this.index.putRaw(threadIndex, key, record.getLogicalAddress(), -1L, false);
            assert (status != -2L);
            if (status == -1L) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status >= 0L) break;
            this.recordProcessor.readRecordForUpdate(-status, this.addressUpdater, threadIndex);
        }
        this.storageInfo.addUsedMemory(record.size());
        this.localUsedMemory += (long)record.size();
        this.storageInfo.increaseEntryCount();
        this.entryCostEstimator.adjustEstimateBy(this.entryCostEstimator.calculateValueCost(record));
        int newMaxRecordChainLength = this.index.getMaxRecordChainLength();
        if (newMaxRecordChainLength > oldMaxRecordChainLength) {
            assert (newMaxRecordChainLength - oldMaxRecordChainLength == 1);
            this.recordProcessor.adjustMaxAcceptedRecordSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TieredStoreRecord updateRecordValue(Data key, TieredStoreRecord oldRecord, Object value) {
        assert (this.index.tryLock(this.threadIndex(), key.hash64()) < 0L);
        Object newValue = this.ess.toData(value, DataType.HEAP);
        if (oldRecord.isUpdatableInPlace((Data)newValue) && this.recordProcessor.isMutable(oldRecord.getLogicalAddress())) {
            oldRecord.setValueSafe((Data)newValue);
            return oldRecord;
        }
        TieredStoreRecord newRecord = null;
        int threadIndex = this.threadIndex();
        block3: while (true) {
            if (newRecord != null) {
                oldRecord = this.get(key);
            }
            while (!this.recordProcessor.isInMemory(oldRecord, threadIndex) || !oldRecord.pin()) {
                if ((oldRecord = this.recordProcessor.readRecordForUpdate(oldRecord.getLogicalAddress(), NOP_REMAPPER, threadIndex)) != Index.RETRY_RECORD) continue;
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue block3;
            }
            try {
                assert (this.recordProcessor.isInMemory(oldRecord, threadIndex));
                newRecord = this.recordFactory.newRecord(oldRecord, (Data)newValue, threadIndex);
            }
            finally {
                oldRecord.unpin();
            }
            long oldRecordLogicalAddress = oldRecord.getLogicalAddress();
            long newRecordLogicalAddress = newRecord.getLogicalAddress();
            long status = this.index.putRaw(threadIndex, key, newRecordLogicalAddress, oldRecordLogicalAddress, true);
            assert (status != 0L);
            if (status > 0L) {
                this.entryCostEstimator.adjustEstimateBy(-this.entryCostEstimator.calculateValueCost(oldRecord));
                this.entryCostEstimator.adjustEstimateBy(this.entryCostEstimator.calculateValueCost(newRecord));
                this.storageInfo.removeUsedMemory(oldRecord.size());
                this.localUsedMemory -= (long)oldRecord.size();
                this.storageInfo.addUsedMemory(newRecord.size());
                this.localUsedMemory += (long)newRecord.size();
                this.device.onGarbage(oldRecordLogicalAddress, oldRecord.size());
                return newRecord;
            }
            if (status == -1L) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status == -2L || status >= 0L) continue;
            this.recordProcessor.readRecordForUpdate(-status, this.addressUpdater, threadIndex);
        }
    }

    @Override
    public TieredStoreRecord get(Data key) {
        TieredStoreRecord readRecord;
        int threadIndex = this.threadIndex();
        while (true) {
            TieredStoreRecord status = this.index.get(threadIndex, key);
            assert (status != Index.UNEXPECTED_RECORD);
            if (status == Index.RETRY_RECORD) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status == null || !status.isPending() && this.hybridLog.isMutable(status.getLogicalAddress())) {
                return status;
            }
            readRecord = this.recordProcessor.readRecordForUpdate(status.getLogicalAddress(), this.addressUpdater, threadIndex);
            if (readRecord == Index.RETRY_RECORD) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (this.keyEquals(readRecord.getLogicalAddress(), readRecord.address(), key)) break;
        }
        return readRecord;
    }

    @Override
    public Record getSafe(Data key) {
        RecordInfo recordInfo = this.getNoCaching(key, true);
        if (recordInfo == null) {
            return null;
        }
        return recordInfo.getRecord();
    }

    public RecordInfo getNoCaching(Data key) {
        return this.getNoCaching(key, false);
    }

    private RecordInfo getNoCaching(Data key, boolean alwaysOnHeap) {
        long logicalAddress;
        int threadIndex = this.threadIndex();
        while (true) {
            logicalAddress = this.index.getRaw(threadIndex, key, -1L, false);
            assert (logicalAddress != -2L);
            if (logicalAddress != -1L) break;
            Thread.yield();
            this.refreshEpochAndState(threadIndex);
        }
        if (logicalAddress == 0L) {
            return null;
        }
        assert (logicalAddress > 0L);
        long physicalAddress = this.hybridLog.asPhysicalAddress(logicalAddress, threadIndex);
        assert (physicalAddress != -1L);
        if (physicalAddress == 0L) {
            byte[] recordBytes = this.recordProcessor.readRecordFromDevice(logicalAddress);
            Record record = this.recordAccessor.newRecord(recordBytes);
            return this.recordInfo.init(record, logicalAddress, recordBytes.length);
        }
        TieredStoreRecord record = this.hybridLog.readRecordFromMemoryForReadOnly(logicalAddress, this.recordAccessor.getTieredStoreSlotAccessor(), threadIndex);
        if (alwaysOnHeap) {
            Record onHeapRecord = this.recordAccessor.newRecordFrom(record);
            return this.recordInfo.init(onHeapRecord, logicalAddress, record.size());
        }
        return this.recordInfo.init(record, logicalAddress, record.size());
    }

    @Override
    public TieredStoreRecord getIfSameKey(Data key) {
        throw new UnsupportedOperationException("TieredStorageImpl#getIfSameKey");
    }

    @Override
    public void removeRecord(Data key, TieredStoreRecord record) {
        int threadIndex = this.threadIndex();
        long expectedLogicalAddress = record.getLogicalAddress();
        while (true) {
            long status = this.index.removeRaw(threadIndex, key, expectedLogicalAddress);
            assert (status != 0L);
            if (status == -1L) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status == -2L) {
                TieredStoreRecord newRecord = this.get(key);
                expectedLogicalAddress = newRecord.getLogicalAddress();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status >= 0L) break;
            this.recordProcessor.readRecordForUpdate(-status, this.addressUpdater, threadIndex);
        }
        this.entryCostEstimator.adjustEstimateBy(-this.entryCostEstimator.calculateValueCost(record));
        int oldRecordSize = record.size();
        this.storageInfo.removeUsedMemory(oldRecordSize);
        this.localUsedMemory -= (long)oldRecordSize;
        this.storageInfo.decreaseEntryCount();
        this.device.onGarbage(expectedLogicalAddress, oldRecordSize);
    }

    public void removeRecord(Data key, long expectedLogicalAddress, int recordSize) {
        long status;
        int threadIndex = this.threadIndex();
        while (true) {
            status = this.index.removeRaw(threadIndex, key, expectedLogicalAddress);
            assert (status != 0L);
            if (status == -1L) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status == -2L) {
                RecordInfo recordInfo = this.getNoCaching(key);
                expectedLogicalAddress = recordInfo.getLogicalAddress();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status >= 0L) break;
            this.recordProcessor.readRecordForUpdate(-status, this.addressUpdater, threadIndex);
        }
        this.entryCostEstimator.adjustEstimateBy(-recordSize);
        int oldRecordSize = recordSize;
        this.storageInfo.removeUsedMemory(oldRecordSize);
        this.localUsedMemory -= (long)oldRecordSize;
        this.storageInfo.decreaseEntryCount();
        this.device.onGarbage(status, oldRecordSize);
    }

    @Override
    public boolean containsKey(Data key) {
        int threadIndex = this.threadIndex();
        while (true) {
            long status = this.index.getRaw(threadIndex, key, -1L, true);
            assert (status != -2L);
            if (status == -1L) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
            } else if (status >= 0L) {
                return status != 0L;
            }
            assert (status < 0L);
            this.recordProcessor.readRecordForReadOnly(-status, this.addressUpdater, threadIndex);
        }
    }

    @Override
    public Iterator<Map.Entry<Data, TieredStoreRecord>> mutationTolerantIterator() {
        return new CachedEntryIterator(this.index.iterator(this.threadIndex()));
    }

    public Iterator<Map.Entry<Data, Record<Data>>> mapEntryNoCachingIterator() {
        return new MapEntryIterator(this.index.mapEntryNoCachingIterator(this.threadIndex()));
    }

    @Override
    public int size() {
        return (int)Math.min(this.index.size(), Integer.MAX_VALUE);
    }

    @Override
    public boolean isEmpty() {
        return this.index.size() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(boolean isDuringShutdown) {
        int threadIndex;
        boolean wasRegisteredToEpoch = this.epoch.isCurrentThreadRegistered();
        if (wasRegisteredToEpoch) {
            threadIndex = this.epoch.getCurrentThreadIndex();
        } else {
            threadIndex = this.epoch.register();
            this.state.register(threadIndex);
        }
        int entryCount = this.size();
        try {
            this.index.clear(threadIndex);
        }
        finally {
            if (!wasRegisteredToEpoch) {
                this.state.unregister(threadIndex);
                this.epoch.unregister(threadIndex);
            }
        }
        this.entryCostEstimator.reset();
        this.storageInfo.removeEntryCount(entryCount);
        this.storageInfo.removeUsedMemory(this.localUsedMemory);
        this.localUsedMemory = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(boolean isDuringShutdown) {
        int threadIndex;
        this.compactorContext.onDestroy();
        this.device.terminateCompactors();
        boolean wasRegisteredToEpoch = this.epoch.isCurrentThreadRegistered();
        if (wasRegisteredToEpoch) {
            threadIndex = this.epoch.getCurrentThreadIndex();
        } else {
            threadIndex = this.epoch.register();
            this.state.register(threadIndex);
        }
        int entryCount = this.size();
        try {
            this.index.close(threadIndex);
            this.hybridLog.dispose();
        }
        finally {
            if (!wasRegisteredToEpoch) {
                this.state.unregister(threadIndex);
                this.epoch.unregister(threadIndex);
            }
            this.entryCostEstimator.reset();
            this.storageInfo.removeEntryCount(entryCount);
            this.storageInfo.removeUsedMemory(this.localUsedMemory);
            this.localUsedMemory = 0L;
        }
    }

    @Override
    public EntryCostEstimator getEntryCostEstimator() {
        return this.entryCostEstimator;
    }

    @Override
    public void setEntryCostEstimator(EntryCostEstimator entryCostEstimator) {
        this.entryCostEstimator = entryCostEstimator;
    }

    @Override
    public Iterable<EntryView> getRandomSamples(int sampleCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MapKeysWithCursor fetchKeys(IterationPointer[] pointers, int size) {
        int threadIndex = this.threadIndex();
        IterationPointer[] updatedPointers = new IterationPointer[pointers.length];
        for (int i = 0; i < updatedPointers.length; ++i) {
            updatedPointers[i] = new IterationPointer(pointers[i]);
        }
        ArrayList<Data> keys = new ArrayList<Data>(size);
        while (true) {
            updatedPointers = this.index.fetchEntries(threadIndex, size - keys.size(), updatedPointers, record -> keys.add(this.recordProcessor.convertData(record.getKey(), DataType.HEAP)));
            if (keys.size() >= size || !Index.isMoreToVisit(updatedPointers)) break;
            Thread.yield();
            this.refreshEpochAndState(threadIndex);
        }
        return new MapKeysWithCursor((List<Data>)keys, updatedPointers);
    }

    @Override
    public MapEntriesWithCursor fetchEntries(IterationPointer[] pointers, int size) {
        int threadIndex = this.threadIndex();
        IterationPointer[] updatedPointers = new IterationPointer[pointers.length];
        for (int i = 0; i < updatedPointers.length; ++i) {
            updatedPointers[i] = new IterationPointer(pointers[i]);
        }
        ArrayList<Map.Entry<Data, Data>> entries = new ArrayList<Map.Entry<Data, Data>>(size);
        while (true) {
            updatedPointers = this.index.fetchEntries(threadIndex, size - entries.size(), updatedPointers, record -> {
                Data key = this.recordProcessor.convertData(record.getKey(), DataType.HEAP);
                Data value = this.recordProcessor.convertData(record.getValue(), DataType.HEAP);
                entries.add(new AbstractMap.SimpleEntry<Data, Data>(key, value));
            });
            if (entries.size() >= size || !Index.isMoreToVisit(updatedPointers)) break;
            Thread.yield();
            this.refreshEpochAndState(threadIndex);
        }
        return new MapEntriesWithCursor((List<Map.Entry<Data, Data>>)entries, updatedPointers);
    }

    @Override
    public Data extractDataKeyFromLazy(EntryView entryView) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Data toBackingDataKeyFormat(Data key) {
        return this.get(key).getKey();
    }

    @Override
    public int beforeOperation() {
        int threadIndex = this.epoch.register();
        this.state.register(threadIndex);
        return threadIndex;
    }

    @Override
    public void afterOperation(int threadIndex) {
        this.state.unregister(threadIndex);
        this.epoch.unregister(threadIndex);
    }

    private int threadIndex() {
        return this.epoch.getCurrentThreadIndex();
    }

    private void refreshEpochAndState(int threadIndex) {
        this.epoch.refresh(threadIndex);
        this.state.refresh(threadIndex);
    }

    public boolean keyEquals(long logicalAddress, long physicalRecord, Data key) {
        long recordKey = this.recordAccessor.readKeyAddress(logicalAddress, physicalRecord);
        return NativeMemoryDataUtil.equals(recordKey, key);
    }

    public Index getIndex() {
        return this.index;
    }

    public TieredStoreRecordProcessor getRecordProcessor() {
        return this.recordProcessor;
    }

    public State getState() {
        return this.state;
    }

    AddressRemapper<TieredStoreRecord> getAddressRemapper() {
        return this.addressUpdater;
    }

    public HybridLogImpl getHybridLog() {
        return this.hybridLog;
    }

    static class RecordInfo {
        private Record record;
        private int size;
        private long logicalAddress;

        RecordInfo() {
        }

        RecordInfo init(Record record, long logicalAddress, int size) {
            this.record = record;
            this.size = size;
            this.logicalAddress = logicalAddress;
            return this;
        }

        Record getRecord() {
            return this.record;
        }

        long getLogicalAddress() {
            return this.logicalAddress;
        }

        int getSize() {
            return this.size;
        }
    }

    public static class IndexDependencies
    implements Index.Dependencies {
        private static final AtomicLongFieldUpdater<IndexDependencies> MEMORY_CONSUMPTION_BYTES = AtomicLongFieldUpdater.newUpdater(IndexDependencies.class, "memoryConsumptionBytes");
        private final TieredStoreRecordProcessor recordProcessor;
        private final TieredStoreRecordAccessor recordAccessor;
        private final AddressRemapper<TieredStoreRecord> addressRemapper;
        private final Epoch epoch;
        private final MemoryAllocator allocator;
        private final EnterpriseSerializationService ess;
        private final InMemorySlotAccessor<TieredStoreRecord, TieredStoreRecord> slotAccessor;
        private volatile long memoryConsumptionBytes;

        public IndexDependencies(TieredStoreRecordProcessor recordProcessor, TieredStoreRecordAccessor recordAccessor, AddressRemapper<TieredStoreRecord> addressRemapper, Epoch epoch, MemoryAllocator allocator, EnterpriseSerializationService ess) {
            this.recordProcessor = recordProcessor;
            this.recordAccessor = recordAccessor;
            this.slotAccessor = recordAccessor.getTieredStoreSlotAccessor();
            this.allocator = allocator;
            this.epoch = epoch;
            this.ess = ess;
            this.addressRemapper = addressRemapper;
        }

        @Override
        public long allocateBuckets(long count) {
            long address = this.allocator.allocate(count * 128L);
            MEMORY_CONSUMPTION_BYTES.addAndGet(this, count * 128L);
            return address;
        }

        @Override
        public void freeBuckets(long buckets, long count) {
            this.allocator.free(buckets, count * 128L);
            MEMORY_CONSUMPTION_BYTES.addAndGet(this, -count * 128L);
        }

        @Override
        public long physicalAddress(long logicalAddress, int threadIndex) {
            return this.recordProcessor.getHybridLog().asPhysicalAddress(logicalAddress, threadIndex);
        }

        @Override
        public long physicalAddressForUpdate(long logicalAddress, int currentThreadIndex) {
            HybridLog log = this.recordProcessor.getHybridLog();
            if (!log.isMutable(logicalAddress)) {
                return 0L;
            }
            return log.asPhysicalAddress(logicalAddress, currentThreadIndex);
        }

        @Override
        public long readRecordForUpdate(long logicalAddress) {
            int currentThreadIndex = this.getEpoch().getCurrentThreadIndex();
            TieredStoreRecord record = this.recordProcessor.readRecordForUpdate(logicalAddress, NOP_REMAPPER, currentThreadIndex);
            if (record == Index.RETRY_RECORD) {
                return -1L;
            }
            return record.getLogicalAddress();
        }

        @Override
        public long readRecordAndDoRemapping(long logicalAddress) {
            int currentThreadIndex = this.getEpoch().getCurrentThreadIndex();
            TieredStoreRecord record = this.recordProcessor.readRecordForReadOnly(logicalAddress, this.addressRemapper, currentThreadIndex);
            if (record == Index.RETRY_RECORD) {
                return -1L;
            }
            return record.getLogicalAddress();
        }

        @Override
        public byte[] readRecordFromDevice(long logicalAddress) {
            return this.recordProcessor.readRecordFromDevice(logicalAddress);
        }

        @Override
        public boolean pinRecordForUpdate(long logicalAddress) {
            return this.recordProcessor.getHybridLog().pinAddress(logicalAddress, PinType.WRITE);
        }

        @Override
        public void unpinRecord(long logicalAddress) {
            this.recordProcessor.getHybridLog().unpinAddress(logicalAddress, PinType.WRITE);
        }

        @Override
        public TieredStoreRecord makeRecord(long physicalAddress, long logicalAddress, int threadIndex) {
            return this.recordProcessor.getHybridLog().readRecordFromMemoryForReadOnly(logicalAddress, this.slotAccessor, threadIndex);
        }

        @Override
        public Map.Entry<Data, Record<Data>> newEntry(byte[] record) {
            return this.recordProcessor.newEntry(record);
        }

        @Override
        public Map.Entry<Data, Record<Data>> newEntry(TieredStoreRecord record) {
            return this.recordProcessor.newEntry(record);
        }

        @Override
        public Data newKey(byte[] record) {
            return this.recordProcessor.newKey(record);
        }

        @Override
        public void keyHashAndNext(long logicalRecord, Index.LongPair keyHashAndNext) {
            int currentThreadIndex = this.epoch.getCurrentThreadIndex();
            long physicalRecord = this.physicalAddress(logicalRecord, currentThreadIndex);
            if (physicalRecord == 0L) {
                byte[] record = this.recordProcessor.readRecordFromDevice(logicalRecord);
                keyHashAndNext.value1 = UnguardedTieredStoreRecordAccessor.keyHash64(record);
                keyHashAndNext.value2 = UnguardedTieredStoreRecordAccessor.getNextRecordAddress(record);
            } else {
                HybridLogDirectAccessor directAccessor = this.recordAccessor.getHybridLog().accessor();
                directAccessor.verifyAccess(logicalRecord, physicalRecord);
                long recordKeyAddress = this.recordAccessor.readKeyAddress(logicalRecord, physicalRecord);
                keyHashAndNext.value1 = NativeMemoryDataUtil.hash64(recordKeyAddress);
                keyHashAndNext.value2 = this.recordAccessor.getNextRecordAddress(logicalRecord, physicalRecord);
            }
        }

        @Override
        public long keyHash(long logicalAddress, long physicalRecord) {
            long recordKeyAddress = this.recordAccessor.readKeyAddress(logicalAddress, physicalRecord);
            return NativeMemoryDataUtil.hash64(recordKeyAddress);
        }

        @Override
        public void markAsReachable(long logicalRecord, int threadIndex) {
            if (!this.isMutable(logicalRecord, threadIndex)) {
                throw new IllegalStateException("only records in mutable region can be marked as reachable.");
            }
            this.recordAccessor.setNotDummy(logicalRecord, threadIndex);
        }

        @Override
        public void markAsNotReachable(long logicalRecord, int threadIndex) {
            if (!this.isMutable(logicalRecord, threadIndex)) {
                return;
            }
            this.recordAccessor.setDummy(logicalRecord, threadIndex);
        }

        private boolean isMutable(long logicalRecord, int threadIndex) {
            HybridLogImpl hybridLog = (HybridLogImpl)this.recordProcessor.getHybridLog();
            return hybridLog.headAddress() < logicalRecord && this.recordProcessor.isMutable(logicalRecord, threadIndex);
        }

        @Override
        public EnterpriseSerializationService serializationService() {
            return this.ess;
        }

        @Override
        public TieredStoreRecordAccessor recordAccessor() {
            return this.recordAccessor;
        }

        @Override
        public Epoch getEpoch() {
            return this.epoch;
        }

        @Override
        public void onDispose() {
            long unreleasedNativeMemory = MEMORY_CONSUMPTION_BYTES.get(this);
            Invariants.equals(0L, unreleasedNativeMemory, "Index has been disposed, native memory consumption by this Index instance should be zero. Is there a memory leak?");
        }

        @Override
        public void pinSegment(int segmentNo) {
            Device device = ((HybridLogImpl)this.recordAccessor.getHybridLog()).getDevice();
            device.pinSegment(segmentNo);
        }

        @Override
        public void unpinSegment(int segmentNo) {
            Device device = ((HybridLogImpl)this.recordAccessor.getHybridLog()).getDevice();
            device.unpinSegment(segmentNo);
        }

        @Override
        public int segmentNoOf(long logicalAddress) {
            return ((HybridLogImpl)this.recordAccessor.getHybridLog()).getDevice().segmentNoOf(logicalAddress);
        }
    }

    private class CachedEntryIterator
    implements Iterator<Map.Entry<Data, TieredStoreRecord>>,
    NotifiableIterator {
        private final MapEntry entry = new MapEntry();
        private final Index.Iterator it;
        private int threadIndex;

        CachedEntryIterator(Index.Iterator it) {
            this.it = it;
            this.threadIndex = TieredStorageImpl.this.threadIndex();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext(this.threadIndex);
        }

        @Override
        public Map.Entry<Data, TieredStoreRecord> next() {
            TieredStoreRecord record = this.it.next(this.threadIndex);
            return this.entry.init(record);
        }

        @Override
        public void onBeforeIteration() {
            this.threadIndex = TieredStorageImpl.this.threadIndex();
        }
    }

    private class MapEntryIterator
    implements Iterator<Map.Entry<Data, Record<Data>>>,
    NotifiableIterator {
        private final Index.MapEntryNoCachingIterator it;
        private int threadIndex;

        MapEntryIterator(Index.MapEntryNoCachingIterator it) {
            this.it = it;
            this.threadIndex = TieredStorageImpl.this.threadIndex();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext(this.threadIndex);
        }

        @Override
        public Map.Entry<Data, Record<Data>> next() {
            return this.it.next(this.threadIndex);
        }

        @Override
        public void onBeforeIteration() {
            this.threadIndex = TieredStorageImpl.this.threadIndex();
        }
    }

    protected static class MapEntry
    implements Map.Entry<Data, TieredStoreRecord> {
        private TieredStoreRecord record;

        protected MapEntry() {
        }

        protected MapEntry init(TieredStoreRecord record) {
            this.record = record;
            return this;
        }

        @Override
        public Data getKey() {
            return this.record.getKey();
        }

        @Override
        public TieredStoreRecord getValue() {
            return this.record;
        }

        @Override
        public TieredStoreRecord setValue(TieredStoreRecord value) {
            TieredStoreRecord oldValue = this.record;
            this.record = value;
            return oldValue;
        }
    }
}

