/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hotrestart.HotRestartKey;
import com.hazelcast.internal.hotrestart.HotRestartStore;
import com.hazelcast.internal.hotrestart.impl.KeyOffHeap;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.record.HDRecord;
import com.hazelcast.map.impl.record.HDRecordFactory;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.recordstore.ForcedEvictable;
import com.hazelcast.map.impl.recordstore.HDStorageImpl;
import com.hazelcast.map.impl.recordstore.HotRestartStorageImpl;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import java.util.Iterator;
import java.util.Map;

public class HotRestartHDStorageImpl
extends HotRestartStorageImpl<HDRecord>
implements ForcedEvictable<Data, HDRecord> {
    private final Object mutex = new Object();

    public HotRestartHDStorageImpl(EnterpriseMapServiceContext mapServiceContext, RecordFactory recordFactory, InMemoryFormat inMemoryFormat, boolean statsEnabled, ExpirySystem expirySystem, boolean fsync, long prefix, int partitionId) {
        super(mapServiceContext, recordFactory, inMemoryFormat, statsEnabled, expirySystem, fsync, prefix, partitionId);
    }

    @Override
    public HotRestartStore getHotRestartStore(int partitionId) {
        return this.mapServiceContext.getOffHeapHotRestartStoreForPartition(partitionId);
    }

    @Override
    public Storage createStorage(RecordFactory recordFactory, InMemoryFormat inMemoryFormat, boolean statsEnabled) {
        SerializationService serializationService = this.mapServiceContext.getNodeEngine().getSerializationService();
        HiDensityRecordProcessor<HDRecord> recordProcessor = ((HDRecordFactory)recordFactory).getRecordProcessor();
        return new HDStorageImpl(recordProcessor, statsEnabled, this.expirySystem, serializationService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Data key, HDRecord record) {
        Object object = this.mutex;
        synchronized (object) {
            this.storage.put(key, record);
        }
        this.putToHotRestart(key, record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HDRecord updateRecordValue(Data key, HDRecord record, Object val) {
        Object object = this.mutex;
        synchronized (object) {
            this.storage.updateRecordValue(key, record, val);
        }
        this.putToHotRestart(key, record);
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRecord(Data key, HDRecord record) {
        this.hotRestartStore.remove(this.createHotRestartKey(key, record), this.fsync);
        Object object = this.mutex;
        synchronized (object) {
            this.storage.removeRecord(key, record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(boolean isDuringShutdown) {
        Object object = this.mutex;
        synchronized (object) {
            this.storage.clear(isDuringShutdown);
        }
        if (!isDuringShutdown) {
            this.hotRestartStore.clear(this.fsync, this.prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(boolean isDuringShutdown) {
        Object object = this.mutex;
        synchronized (object) {
            this.storage.destroy(isDuringShutdown);
        }
        if (!isDuringShutdown) {
            this.hotRestartStore.clear(this.fsync, this.prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeDeferredBlocks() {
        Object object = this.mutex;
        synchronized (object) {
            super.disposeDeferredBlocks();
        }
    }

    @Override
    public Iterator<Map.Entry<Data, HDRecord>> newRandomEvictionEntryIterator() {
        return ((ForcedEvictable)((Object)this.storage)).newRandomEvictionEntryIterator();
    }

    @Override
    public HotRestartKey createHotRestartKey(Data onHeapKey, Record record) {
        long keyAddress = this.getStorageImpl().getNativeKeyAddress(onHeapKey);
        return new KeyOffHeap(this.prefix, onHeapKey.toByteArray(), keyAddress, record.getSequence());
    }

    public long getNativeKeyAddress(Data key) {
        return this.getStorageImpl().getNativeKeyAddress(key);
    }

    public NativeMemoryData toNative(Data data) {
        return this.getStorageImpl().toNative(data);
    }

    public HDStorageImpl getStorageImpl() {
        return (HDStorageImpl)this.storage;
    }

    public Object getMutex() {
        return this.mutex;
    }
}

