/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.compaction.CompactorFlags;
import com.hazelcast.internal.tstore.compaction.DataPartitionCompactorStep;
import com.hazelcast.internal.tstore.compaction.DeviceCapacityCheckStep;
import com.hazelcast.internal.tstore.compaction.IndexBasedHLogCompactorConstructorFn;
import com.hazelcast.internal.tstore.compaction.LogBasedHLogCompactorConstructorFn;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.function.Supplier;

public class CompactorContext {
    private final int partitionId;
    private final TStoreUserId userId;
    private final CompactorFlags compactorFlags;
    private Step partitionCompactorStep;
    private CompactionManager compactionManager;
    private LogBasedHLogCompactorConstructorFn logBasedConstructorFn;
    private IndexBasedHLogCompactorConstructorFn indexBasedConstructorFn;

    public CompactorContext(HybridLogImpl hybridLog, int partitionId, Index index, State state, TStoreUserId userId, Supplier<CompactionManager> compactionManagerSupplier, TieredStoreRecordAccessor recordAccessor, HazelcastProperties properties) {
        this.userId = userId;
        this.partitionId = partitionId;
        this.compactorFlags = ((LocalStorageDevice)hybridLog.getDevice()).getCompactionStats().getCompactorFlags();
        if (!this.compactorFlags.isCompactorsEnabled()) {
            this.initCompactorFields(new DeviceCapacityCheckStep(), null, null, null);
        } else if (this.compactorFlags.isPartitionCompactorEnabled()) {
            this.initCompactorFields(new DataPartitionCompactorStep(), null, null, null);
        } else {
            this.initConcurrentCompactors(hybridLog, partitionId, index, state, userId, compactionManagerSupplier, recordAccessor, properties);
        }
    }

    private void initConcurrentCompactors(HybridLogImpl hybridLog, int partitionId, Index index, State state, TStoreUserId userId, Supplier<CompactionManager> compactionManagerSupplier, TieredStoreRecordAccessor recordAccessor, HazelcastProperties properties) {
        this.compactionManager = compactionManagerSupplier.get();
        assert (this.compactionManager != null);
        LogBasedHLogCompactorConstructorFn logBasedConstructorFn = new LogBasedHLogCompactorConstructorFn(this.compactionManager, recordAccessor, hybridLog, index, state, properties);
        IndexBasedHLogCompactorConstructorFn indexBasedConstructorFn = new IndexBasedHLogCompactorConstructorFn(index, state, hybridLog);
        this.compactionManager.addCompactorConstructorFn(userId, partitionId, logBasedConstructorFn);
        this.compactionManager.addCompactorConstructorFn(userId, partitionId, indexBasedConstructorFn);
        this.initCompactorFields(null, this.compactionManager, logBasedConstructorFn, indexBasedConstructorFn);
    }

    private void initCompactorFields(Step partitionCompactorStep, CompactionManager compactionManager, LogBasedHLogCompactorConstructorFn logBasedConstructorFn, IndexBasedHLogCompactorConstructorFn indexBasedConstructorFn) {
        this.partitionCompactorStep = partitionCompactorStep;
        this.compactionManager = compactionManager;
        this.logBasedConstructorFn = logBasedConstructorFn;
        this.indexBasedConstructorFn = indexBasedConstructorFn;
    }

    public CompactorFlags getCompactorFlags() {
        return this.compactorFlags;
    }

    public Step getPartitionCompactorStep() {
        return this.partitionCompactorStep;
    }

    public void onDestroy() {
        if (!this.compactorFlags.isPartitionCompactorEnabled() && this.compactorFlags.isCompactorsEnabled()) {
            this.compactionManager.removeCompactorConstructorFn(this.userId, this.partitionId, this.logBasedConstructorFn);
            this.compactionManager.removeCompactorConstructorFn(this.userId, this.partitionId, this.indexBasedConstructorFn);
        }
    }
}

