/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps.engine;

import com.hazelcast.core.Offloadable;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.operation.ForcedEviction;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.LinkerStep;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.CustomStepAwareStorage;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerImpl;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class StepSupplier
implements Supplier<Runnable>,
Consumer<Step> {
    private final State state;
    private final OperationRunnerImpl operationRunner;
    private final boolean checkCurrentThread;
    private volatile Runnable currentRunnable;
    private volatile Step currentStep;
    private volatile boolean firstStep = true;

    public StepSupplier(MapOperation operation) {
        this(operation, true);
    }

    StepSupplier(MapOperation operation, boolean checkCurrentThread) {
        assert (operation != null);
        this.state = operation.createState();
        this.currentStep = operation.getStartingStep();
        StepSupplier.collectCustomSteps(operation, this);
        this.operationRunner = UtilSteps.getPartitionOperationRunner(this.state);
        this.checkCurrentThread = checkCurrentThread;
        assert (this.currentStep != null);
    }

    @Override
    public void accept(Step headStep) {
        if (headStep == null) {
            return;
        }
        this.currentStep = LinkerStep.linkSteps(headStep, this.currentStep);
    }

    public static void collectCustomSteps(MapOperation operation, Consumer<Step> consumer) {
        Storage storage = operation.getRecordStore().getStorage();
        if (storage instanceof CustomStepAwareStorage) {
            ((CustomStepAwareStorage)((Object)storage)).collectCustomSteps(consumer);
        }
    }

    public static Step injectCustomStepsToOperation(MapOperation operation, Step injectCustomStepsBeforeThisStep) {
        ArrayList steps = new ArrayList();
        StepSupplier.collectCustomSteps(operation, customStep -> {
            if (customStep == null) {
                return;
            }
            steps.add(customStep);
        });
        Step injectionStep = injectCustomStepsBeforeThisStep;
        for (int i = 0; i < steps.size(); ++i) {
            injectionStep = LinkerStep.linkSteps((Step)steps.get(i), injectionStep);
        }
        return injectionStep;
    }

    Step getCurrentStep() {
        return this.currentStep;
    }

    @Override
    public Runnable get() {
        if (this.currentRunnable == null && this.currentStep != null) {
            this.currentRunnable = this.createRunnable(this.currentStep, this.state);
        }
        return this.currentRunnable;
    }

    private Runnable createRunnable(final Step step, final State state) {
        if (step == null) {
            return null;
        }
        if (step.isOffloadStep(state)) {
            return new ExecutorNameAwareRunnable(){

                @Override
                public String getExecutorName() {
                    return step.getExecutorName(state);
                }

                @Override
                public void run() {
                    assert (!StepSupplier.this.checkCurrentThread || !ThreadUtil.isRunningOnPartitionThread());
                    StepSupplier.this.runStepWithState(step, state);
                }

                public String toString() {
                    return step.toString();
                }
            };
        }
        return new PartitionSpecificRunnable(){

            @Override
            public void run() {
                assert (!StepSupplier.this.checkCurrentThread || ThreadUtil.isRunningOnPartitionThread());
                StepSupplier.this.runStepWithState(step, state);
            }

            @Override
            public int getPartitionId() {
                return state.getPartitionId();
            }

            public String toString() {
                return step.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStepWithState(Step step, State state) {
        block18: {
            boolean runningOnPartitionThread = ThreadUtil.isRunningOnPartitionThread();
            boolean metWithPreconditions = true;
            try {
                boolean errorStep;
                this.refreshSate(state);
                int threadIndex = -1;
                boolean bl = errorStep = step == UtilSteps.HANDLE_ERROR;
                if (!errorStep) {
                    threadIndex = state.getRecordStore().beforeOperation();
                }
                try {
                    if (runningOnPartitionThread && state.getThrowable() == null) {
                        metWithPreconditions = this.metWithPreconditions();
                    }
                    if (metWithPreconditions) {
                        step.runStep(state);
                    }
                }
                catch (NativeOutOfMemoryError e) {
                    if (runningOnPartitionThread) {
                        this.rerunWithForcedEviction(() -> step.runStep(state));
                        break block18;
                    }
                    throw e;
                }
                finally {
                    if (!errorStep) {
                        state.getRecordStore().afterOperation(threadIndex);
                    }
                }
            }
            catch (Throwable throwable) {
                if (runningOnPartitionThread) {
                    state.getOperation().disposeDeferredBlocks();
                }
                state.setThrowable(throwable);
            }
            finally {
                if (metWithPreconditions) {
                    this.currentStep = this.nextStep(step);
                    this.currentRunnable = this.createRunnable(this.currentStep, state);
                } else {
                    this.currentStep = null;
                    this.currentRunnable = null;
                }
            }
        }
    }

    private void refreshSate(State state) {
        MapOperation operation = state.getOperation();
        boolean mapExists = operation.checkMapExists();
        RecordStore<Record> recordStore = operation.getRecordStore();
        if (!mapExists || recordStore == null) {
            state.setThrowable(new DistributedObjectDestroyedException("No such map exists with name=" + operation.getName() + ", op=" + operation.getClass().getSimpleName()));
            return;
        }
        state.init(recordStore, operation);
    }

    private boolean metWithPreconditions() {
        assert (ThreadUtil.isRunningOnPartitionThread());
        this.operationRunner.ensureNodeAndClusterHealth(this.state.getOperation());
        if (this.firstStep) {
            assert (this.firstStep);
            this.firstStep = false;
            return !this.operationRunner.timeout(this.state.getOperation());
        }
        return true;
    }

    private Step nextStep(Step step) {
        if (this.state.getThrowable() != null && this.currentStep != UtilSteps.HANDLE_ERROR) {
            return UtilSteps.HANDLE_ERROR;
        }
        return step.nextStep(this.state);
    }

    private void rerunWithForcedEviction(Runnable step) {
        ForcedEviction.runStepWithForcedEvictionStrategies(this.state.getOperation(), step);
    }

    public void handleOperationError(Throwable throwable) {
        this.state.setThrowable(throwable);
        this.currentRunnable = null;
        this.currentStep = UtilSteps.HANDLE_ERROR;
    }

    public MapOperation getOperation() {
        return this.state.getOperation();
    }

    private static interface ExecutorNameAwareRunnable
    extends Runnable,
    Offloadable {
    }
}

